/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Assessment;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class AssessmentJsonMarshaller {
    private static AssessmentJsonMarshaller instance;

    public void marshall(Assessment assessment, SdkJsonGenerator jsonGenerator) {
        if (assessment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesForFindingsList;
            jsonGenerator.writeStartObject();
            if (assessment.getAssessmentArn() != null) {
                jsonGenerator.writeFieldName("assessmentArn").writeValue(assessment.getAssessmentArn());
            }
            if (assessment.getAssessmentName() != null) {
                jsonGenerator.writeFieldName("assessmentName").writeValue(assessment.getAssessmentName());
            }
            if (assessment.getApplicationArn() != null) {
                jsonGenerator.writeFieldName("applicationArn").writeValue(assessment.getApplicationArn());
            }
            if (assessment.getAssessmentState() != null) {
                jsonGenerator.writeFieldName("assessmentState").writeValue(assessment.getAssessmentState());
            }
            if (assessment.getFailureMessage() != null) {
                jsonGenerator.writeFieldName("failureMessage").writeValue(assessment.getFailureMessage());
            }
            if (assessment.getDataCollected() != null) {
                jsonGenerator.writeFieldName("dataCollected").writeValue(assessment.getDataCollected().booleanValue());
            }
            if (assessment.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(assessment.getStartTime());
            }
            if (assessment.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(assessment.getEndTime());
            }
            if (assessment.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue((long)assessment.getDurationInSeconds().intValue());
            }
            if ((userAttributesForFindingsList = assessment.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentJsonMarshaller();
        }
        return instance;
    }
}

