/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.FindingFilter;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class FindingFilterJsonMarshaller {
    private static FindingFilterJsonMarshaller instance;

    public void marshall(FindingFilter findingFilter, StructuredJsonGenerator jsonGenerator) {
        if (findingFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> list;
            List<Attribute> list2;
            List<String> list3;
            List<String> list4;
            List<String> list5;
            List<String> autoScalingGroupsList;
            jsonGenerator.writeStartObject();
            List<String> agentIdsList = findingFilter.getAgentIds();
            if (agentIdsList != null) {
                jsonGenerator.writeFieldName("agentIds");
                jsonGenerator.writeStartArray();
                for (String string : agentIdsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((autoScalingGroupsList = findingFilter.getAutoScalingGroups()) != null) {
                jsonGenerator.writeFieldName("autoScalingGroups");
                jsonGenerator.writeStartArray();
                for (String string : autoScalingGroupsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list5 = findingFilter.getRuleNames()) != null) {
                jsonGenerator.writeFieldName("ruleNames");
                jsonGenerator.writeStartArray();
                for (String string : list5) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list4 = findingFilter.getSeverities()) != null) {
                jsonGenerator.writeFieldName("severities");
                jsonGenerator.writeStartArray();
                for (String string : list4) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list3 = findingFilter.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String string : list3) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = findingFilter.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : list2) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = findingFilter.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("userAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesListValue : list) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (findingFilter.getCreationTimeRange() != null) {
                jsonGenerator.writeFieldName("creationTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(findingFilter.getCreationTimeRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingFilterJsonMarshaller();
        }
        return instance;
    }
}

