/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListRunsRequest;
import com.amazonaws.services.inspector.model.transform.RunsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListRunsRequestMarshaller
implements Marshaller<Request<ListRunsRequest>, ListRunsRequest> {
    public Request<ListRunsRequest> marshall(ListRunsRequest listRunsRequest) {
        if (listRunsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRunsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListRuns");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentArnsList = listRunsRequest.getAssessmentArns();
            if (assessmentArnsList != null) {
                jsonGenerator.writeFieldName("assessmentArns");
                jsonGenerator.writeStartArray();
                for (String assessmentArnsListValue : assessmentArnsList) {
                    if (assessmentArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listRunsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                RunsFilterJsonMarshaller.getInstance().marshall(listRunsRequest.getFilter(), jsonGenerator);
            }
            if (listRunsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listRunsRequest.getNextToken());
            }
            if (listRunsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)listRunsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

