/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.RunsFilter;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class RunsFilterJsonMarshaller {
    private static RunsFilterJsonMarshaller instance;

    public void marshall(RunsFilter runsFilter, SdkJsonGenerator jsonGenerator) {
        if (runsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<String> runStatesList;
            jsonGenerator.writeStartObject();
            List<String> runNamePatternsList = runsFilter.getRunNamePatterns();
            if (runNamePatternsList != null) {
                jsonGenerator.writeFieldName("runNamePatterns");
                jsonGenerator.writeStartArray();
                for (String string : runNamePatternsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((runStatesList = runsFilter.getRunStates()) != null) {
                jsonGenerator.writeFieldName("runStates");
                jsonGenerator.writeStartArray();
                for (String runStatesListValue : runStatesList) {
                    if (runStatesListValue == null) continue;
                    jsonGenerator.writeValue(runStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = runsFilter.getRulesPackages()) != null) {
                jsonGenerator.writeFieldName("rulesPackages");
                jsonGenerator.writeStartArray();
                for (String rulesPackagesListValue : list) {
                    if (rulesPackagesListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackagesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (runsFilter.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime");
                TimestampRangeJsonMarshaller.getInstance().marshall(runsFilter.getCreationTime(), jsonGenerator);
            }
            if (runsFilter.getCompletionTime() != null) {
                jsonGenerator.writeFieldName("completionTime");
                TimestampRangeJsonMarshaller.getInstance().marshall(runsFilter.getCompletionTime(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunsFilterJsonMarshaller();
        }
        return instance;
    }
}

