/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListAssessmentsRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListAssessmentsRequestMarshaller
implements Marshaller<Request<ListAssessmentsRequest>, ListAssessmentsRequest> {
    public Request<ListAssessmentsRequest> marshall(ListAssessmentsRequest listAssessmentsRequest) {
        if (listAssessmentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAssessmentsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<String> applicationArnsList = listAssessmentsRequest.getApplicationArns();
            if (applicationArnsList != null) {
                jsonGenerator.writeFieldName("applicationArns");
                jsonGenerator.writeStartArray();
                for (String applicationArnsListValue : applicationArnsList) {
                    if (applicationArnsListValue == null) continue;
                    jsonGenerator.writeValue(applicationArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAssessmentsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentsFilterJsonMarshaller.getInstance().marshall(listAssessmentsRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentsRequest.getNextToken());
            }
            if (listAssessmentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)listAssessmentsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

