/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.LocalizeTextRequest;
import com.amazonaws.services.inspector.model.LocalizedText;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class LocalizeTextRequestMarshaller
implements Marshaller<Request<LocalizeTextRequest>, LocalizeTextRequest> {
    public Request<LocalizeTextRequest> marshall(LocalizeTextRequest localizeTextRequest) {
        if (localizeTextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)localizeTextRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.LocalizeText");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<LocalizedText> localizedTextsList = localizeTextRequest.getLocalizedTexts();
            if (localizedTextsList != null) {
                jsonGenerator.writeFieldName("localizedTexts");
                jsonGenerator.writeStartArray();
                for (LocalizedText localizedTextsListValue : localizedTextsList) {
                    if (localizedTextsListValue == null) continue;
                    LocalizedTextJsonMarshaller.getInstance().marshall(localizedTextsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (localizeTextRequest.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(localizeTextRequest.getLocale());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

