/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.LocalizedText;
import com.amazonaws.services.inspector.model.Parameter;
import com.amazonaws.services.inspector.model.transform.LocalizedTextKeyJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.ParameterJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class LocalizedTextJsonMarshaller {
    private static LocalizedTextJsonMarshaller instance;

    public void marshall(LocalizedText localizedText, SdkJsonGenerator jsonGenerator) {
        if (localizedText == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Parameter> parametersList;
            jsonGenerator.writeStartObject();
            if (localizedText.getKey() != null) {
                jsonGenerator.writeFieldName("key");
                LocalizedTextKeyJsonMarshaller.getInstance().marshall(localizedText.getKey(), jsonGenerator);
            }
            if ((parametersList = localizedText.getParameters()) != null) {
                jsonGenerator.writeFieldName("parameters");
                jsonGenerator.writeStartArray();
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue == null) continue;
                    ParameterJsonMarshaller.getInstance().marshall(parametersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalizedTextJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalizedTextJsonMarshaller();
        }
        return instance;
    }
}

