/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.ResourceGroupTag;
import com.amazonaws.services.inspector.model.transform.ResourceGroupTagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateResourceGroupRequestMarshaller
implements Marshaller<Request<CreateResourceGroupRequest>, CreateResourceGroupRequest> {
    public Request<CreateResourceGroupRequest> marshall(CreateResourceGroupRequest createResourceGroupRequest) {
        if (createResourceGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createResourceGroupRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateResourceGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<ResourceGroupTag> resourceGroupTagsList = createResourceGroupRequest.getResourceGroupTags();
            if (resourceGroupTagsList != null) {
                jsonGenerator.writeFieldName("resourceGroupTags");
                jsonGenerator.writeStartArray();
                for (ResourceGroupTag resourceGroupTagsListValue : resourceGroupTagsList) {
                    if (resourceGroupTagsListValue == null) continue;
                    ResourceGroupTagJsonMarshaller.getInstance().marshall(resourceGroupTagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

