/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeAssessmentTargetsRequestMarshaller
implements Marshaller<Request<DescribeAssessmentTargetsRequest>, DescribeAssessmentTargetsRequest> {
    public Request<DescribeAssessmentTargetsRequest> marshall(DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) {
        if (describeAssessmentTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAssessmentTargetsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeAssessmentTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentTargetArnsList = describeAssessmentTargetsRequest.getAssessmentTargetArns();
            if (assessmentTargetArnsList != null) {
                jsonGenerator.writeFieldName("assessmentTargetArns");
                jsonGenerator.writeStartArray();
                for (String assessmentTargetArnsListValue : assessmentTargetArnsList) {
                    if (assessmentTargetArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentTargetArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

