/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.inspector.AmazonInspector;
import com.amazonaws.services.inspector.model.AccessDeniedException;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsResult;
import com.amazonaws.services.inspector.model.AgentsAlreadyRunningAssessmentException;
import com.amazonaws.services.inspector.model.AssessmentRunInProgressException;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetResult;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateResult;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.CreateResourceGroupResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentRunRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.DescribeFindingsRequest;
import com.amazonaws.services.inspector.model.DescribeFindingsResult;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsRequest;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsResult;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesRequest;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesResult;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataRequest;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataResult;
import com.amazonaws.services.inspector.model.InternalException;
import com.amazonaws.services.inspector.model.InvalidCrossAccountRoleException;
import com.amazonaws.services.inspector.model.InvalidInputException;
import com.amazonaws.services.inspector.model.LimitExceededException;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsResult;
import com.amazonaws.services.inspector.model.ListAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsRequest;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsResult;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.ListFindingsResult;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector.model.NoSuchEntityException;
import com.amazonaws.services.inspector.model.PreviewAgentsRequest;
import com.amazonaws.services.inspector.model.PreviewAgentsResult;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsResult;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.StartAssessmentRunRequest;
import com.amazonaws.services.inspector.model.StartAssessmentRunResult;
import com.amazonaws.services.inspector.model.StopAssessmentRunRequest;
import com.amazonaws.services.inspector.model.SubscribeToEventRequest;
import com.amazonaws.services.inspector.model.UnsubscribeFromEventRequest;
import com.amazonaws.services.inspector.model.UpdateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTargetRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTargetResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTemplateRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTargetRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTemplateRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentRunsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentRunsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTargetsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTargetsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTemplatesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.GetTelemetryMetadataRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.GetTelemetryMetadataResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunAgentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunAgentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTargetsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTargetsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTemplatesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListEventSubscriptionsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListEventSubscriptionsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RegisterCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.SetTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StartAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StartAssessmentRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.StopAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.SubscribeToEventRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UnsubscribeFromEventRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateAssessmentTargetRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonInspectorClient
extends AmazonWebServiceClient
implements AmazonInspector {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonInspector.class);
    private static final String DEFAULT_SIGNING_NAME = "inspector";
    private static final String DEFAULT_ENDPOINT_PREFIX = "inspector";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonInspectorClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonInspectorClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchEntityException.class, "NoSuchEntityException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidInputException.class, "InvalidInputException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalException.class, "InternalException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AccessDeniedException.class, "AccessDeniedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AgentsAlreadyRunningAssessmentException.class, "AgentsAlreadyRunningAssessmentException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssessmentRunInProgressException.class, "AssessmentRunInProgressException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCrossAccountRoleException.class, "InvalidCrossAccountRoleException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("inspector");
        this.setEndpointPrefix("inspector");
        this.setEndpoint("https://inspector.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/inspector/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/inspector/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddAttributesToFindingsResult addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addAttributesToFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddAttributesToFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddAttributesToFindingsRequestMarshaller().marshall((AddAttributesToFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addAttributesToFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new AddAttributesToFindingsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddAttributesToFindingsResult addAttributesToFindingsResult = (AddAttributesToFindingsResult)response.getAwsResponse();
            return addAttributesToFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTargetResult createAssessmentTarget(CreateAssessmentTargetRequest createAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssessmentTargetRequestMarshaller().marshall((CreateAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateAssessmentTargetResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateAssessmentTargetResult createAssessmentTargetResult = (CreateAssessmentTargetResult)response.getAwsResponse();
            return createAssessmentTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTemplateResult createAssessmentTemplate(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssessmentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssessmentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssessmentTemplateRequestMarshaller().marshall((CreateAssessmentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAssessmentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateAssessmentTemplateResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateAssessmentTemplateResult createAssessmentTemplateResult = (CreateAssessmentTemplateResult)response.getAwsResponse();
            return createAssessmentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceGroupResult createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResourceGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResourceGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResourceGroupRequestMarshaller().marshall((CreateResourceGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createResourceGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateResourceGroupResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateResourceGroupResult createResourceGroupResult = (CreateResourceGroupResult)response.getAwsResponse();
            return createResourceGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAssessmentRun(DeleteAssessmentRunRequest deleteAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentRunRequestMarshaller().marshall((DeleteAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAssessmentTarget(DeleteAssessmentTargetRequest deleteAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentTargetRequestMarshaller().marshall((DeleteAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAssessmentTemplate(DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentTemplateRequestMarshaller().marshall((DeleteAssessmentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentRunsResult describeAssessmentRuns(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentRunsRequestMarshaller().marshall((DescribeAssessmentRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeAssessmentRunsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAssessmentRunsResult describeAssessmentRunsResult = (DescribeAssessmentRunsResult)response.getAwsResponse();
            return describeAssessmentRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTargetsResult describeAssessmentTargets(DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentTargetsRequestMarshaller().marshall((DescribeAssessmentTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeAssessmentTargetsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAssessmentTargetsResult describeAssessmentTargetsResult = (DescribeAssessmentTargetsResult)response.getAwsResponse();
            return describeAssessmentTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTemplatesResult describeAssessmentTemplates(DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentTemplatesRequestMarshaller().marshall((DescribeAssessmentTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeAssessmentTemplatesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAssessmentTemplatesResult describeAssessmentTemplatesResult = (DescribeAssessmentTemplatesResult)response.getAwsResponse();
            return describeAssessmentTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCrossAccountAccessRoleRequestMarshaller().marshall((DescribeCrossAccountAccessRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeCrossAccountAccessRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeCrossAccountAccessRoleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRoleResult = (DescribeCrossAccountAccessRoleResult)response.getAwsResponse();
            return describeCrossAccountAccessRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFindingsResult describeFindings(DescribeFindingsRequest describeFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFindingsRequestMarshaller().marshall((DescribeFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeFindingsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFindingsResult describeFindingsResult = (DescribeFindingsResult)response.getAwsResponse();
            return describeFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceGroupsResult describeResourceGroups(DescribeResourceGroupsRequest describeResourceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourceGroupsRequestMarshaller().marshall((DescribeResourceGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeResourceGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeResourceGroupsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeResourceGroupsResult describeResourceGroupsResult = (DescribeResourceGroupsResult)response.getAwsResponse();
            return describeResourceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRulesPackagesResult describeRulesPackages(DescribeRulesPackagesRequest describeRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRulesPackagesRequestMarshaller().marshall((DescribeRulesPackagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRulesPackagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeRulesPackagesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeRulesPackagesResult describeRulesPackagesResult = (DescribeRulesPackagesResult)response.getAwsResponse();
            return describeRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTelemetryMetadataResult getTelemetryMetadata(GetTelemetryMetadataRequest getTelemetryMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTelemetryMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTelemetryMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTelemetryMetadataRequestMarshaller().marshall((GetTelemetryMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTelemetryMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetTelemetryMetadataResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetTelemetryMetadataResult getTelemetryMetadataResult = (GetTelemetryMetadataResult)response.getAwsResponse();
            return getTelemetryMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunAgentsResult listAssessmentRunAgents(ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentRunAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentRunAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentRunAgentsRequestMarshaller().marshall((ListAssessmentRunAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentRunAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListAssessmentRunAgentsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentRunAgentsResult listAssessmentRunAgentsResult = (ListAssessmentRunAgentsResult)response.getAwsResponse();
            return listAssessmentRunAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunsResult listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentRunsRequestMarshaller().marshall((ListAssessmentRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListAssessmentRunsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentRunsResult listAssessmentRunsResult = (ListAssessmentRunsResult)response.getAwsResponse();
            return listAssessmentRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTargetsResult listAssessmentTargets(ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentTargetsRequestMarshaller().marshall((ListAssessmentTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListAssessmentTargetsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentTargetsResult listAssessmentTargetsResult = (ListAssessmentTargetsResult)response.getAwsResponse();
            return listAssessmentTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTemplatesResult listAssessmentTemplates(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentTemplatesRequestMarshaller().marshall((ListAssessmentTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListAssessmentTemplatesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentTemplatesResult listAssessmentTemplatesResult = (ListAssessmentTemplatesResult)response.getAwsResponse();
            return listAssessmentTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSubscriptionsResult listEventSubscriptions(ListEventSubscriptionsRequest listEventSubscriptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventSubscriptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventSubscriptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventSubscriptionsRequestMarshaller().marshall((ListEventSubscriptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventSubscriptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListEventSubscriptionsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListEventSubscriptionsResult listEventSubscriptionsResult = (ListEventSubscriptionsResult)response.getAwsResponse();
            return listEventSubscriptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResult listFindings(ListFindingsRequest listFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsRequestMarshaller().marshall((ListFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListFindingsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListFindingsResult listFindingsResult = (ListFindingsResult)response.getAwsResponse();
            return listFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesPackagesResult listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesPackagesRequestMarshaller().marshall((ListRulesPackagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRulesPackagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListRulesPackagesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRulesPackagesResult listRulesPackagesResult = (ListRulesPackagesResult)response.getAwsResponse();
            return listRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestMarshaller().marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreviewAgentsResult previewAgents(PreviewAgentsRequest previewAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(previewAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PreviewAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PreviewAgentsRequestMarshaller().marshall((PreviewAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)previewAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new PreviewAgentsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PreviewAgentsResult previewAgentsResult = (PreviewAgentsResult)response.getAwsResponse();
            return previewAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterCrossAccountAccessRoleRequestMarshaller().marshall((RegisterCrossAccountAccessRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerCrossAccountAccessRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAttributesFromFindingsResult removeAttributesFromFindings(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeAttributesFromFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveAttributesFromFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveAttributesFromFindingsRequestMarshaller().marshall((RemoveAttributesFromFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeAttributesFromFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new RemoveAttributesFromFindingsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveAttributesFromFindingsResult removeAttributesFromFindingsResult = (RemoveAttributesFromFindingsResult)response.getAwsResponse();
            return removeAttributesFromFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTagsForResourceRequestMarshaller().marshall((SetTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)setTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAssessmentRunResult startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartAssessmentRunRequestMarshaller().marshall((StartAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)startAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new StartAssessmentRunResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StartAssessmentRunResult startAssessmentRunResult = (StartAssessmentRunResult)response.getAwsResponse();
            return startAssessmentRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopAssessmentRunRequestMarshaller().marshall((StopAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeToEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeToEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeToEventRequestMarshaller().marshall((SubscribeToEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)subscribeToEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeFromEvent(UnsubscribeFromEventRequest unsubscribeFromEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeFromEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeFromEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeFromEventRequestMarshaller().marshall((UnsubscribeFromEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)unsubscribeFromEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAssessmentTarget(UpdateAssessmentTargetRequest updateAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssessmentTargetRequestMarshaller().marshall((UpdateAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = SdkJsonProtocolFactory.createErrorResponseHandler(this.jsonErrorUnmarshallers, (boolean)false);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

