/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.inspector.AmazonInspector;
import com.amazonaws.services.inspector.model.AccessDeniedException;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsResult;
import com.amazonaws.services.inspector.model.AgentsAlreadyRunningAssessmentException;
import com.amazonaws.services.inspector.model.AssessmentRunInProgressException;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetResult;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateResult;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.CreateResourceGroupResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentRunRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentRunResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTargetResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTemplateResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.DescribeFindingsRequest;
import com.amazonaws.services.inspector.model.DescribeFindingsResult;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsRequest;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsResult;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesRequest;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesResult;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataRequest;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataResult;
import com.amazonaws.services.inspector.model.InternalException;
import com.amazonaws.services.inspector.model.InvalidCrossAccountRoleException;
import com.amazonaws.services.inspector.model.InvalidInputException;
import com.amazonaws.services.inspector.model.LimitExceededException;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsResult;
import com.amazonaws.services.inspector.model.ListAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsRequest;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsResult;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.ListFindingsResult;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector.model.NoSuchEntityException;
import com.amazonaws.services.inspector.model.PreviewAgentsRequest;
import com.amazonaws.services.inspector.model.PreviewAgentsResult;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsResult;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.SetTagsForResourceResult;
import com.amazonaws.services.inspector.model.StartAssessmentRunRequest;
import com.amazonaws.services.inspector.model.StartAssessmentRunResult;
import com.amazonaws.services.inspector.model.StopAssessmentRunRequest;
import com.amazonaws.services.inspector.model.StopAssessmentRunResult;
import com.amazonaws.services.inspector.model.SubscribeToEventRequest;
import com.amazonaws.services.inspector.model.SubscribeToEventResult;
import com.amazonaws.services.inspector.model.UnsubscribeFromEventRequest;
import com.amazonaws.services.inspector.model.UnsubscribeFromEventResult;
import com.amazonaws.services.inspector.model.UpdateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.UpdateAssessmentTargetResult;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTargetRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTargetResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTemplateRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTargetRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTargetResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTemplateRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentTemplateResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentRunsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentRunsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTargetsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTargetsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTemplatesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.GetTelemetryMetadataRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.GetTelemetryMetadataResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunAgentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunAgentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentRunsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTargetsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTargetsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTemplatesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListEventSubscriptionsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListEventSubscriptionsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RegisterCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RegisterCrossAccountAccessRoleResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.SetTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.SetTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.StartAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StartAssessmentRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.StopAssessmentRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StopAssessmentRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.SubscribeToEventRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.SubscribeToEventResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.UnsubscribeFromEventRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UnsubscribeFromEventResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateAssessmentTargetRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateAssessmentTargetResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonInspectorClient
extends AmazonWebServiceClient
implements AmazonInspector {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonInspector.class);
    private static final String DEFAULT_SIGNING_NAME = "inspector";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoSuchEntityException").withModeledClass(NoSuchEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withModeledClass(InternalException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AgentsAlreadyRunningAssessmentException").withModeledClass(AgentsAlreadyRunningAssessmentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AssessmentRunInProgressException").withModeledClass(AssessmentRunInProgressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidCrossAccountRoleException").withModeledClass(InvalidCrossAccountRoleException.class)));

    public AmazonInspectorClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonInspectorClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://inspector.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/inspector/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/inspector/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddAttributesToFindingsResult addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addAttributesToFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddAttributesToFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddAttributesToFindingsRequestMarshaller(this.protocolFactory).marshall((AddAttributesToFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addAttributesToFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddAttributesToFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddAttributesToFindingsResult addAttributesToFindingsResult = (AddAttributesToFindingsResult)response.getAwsResponse();
            return addAttributesToFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTargetResult createAssessmentTarget(CreateAssessmentTargetRequest createAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssessmentTargetRequestMarshaller(this.protocolFactory).marshall((CreateAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAssessmentTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssessmentTargetResult createAssessmentTargetResult = (CreateAssessmentTargetResult)response.getAwsResponse();
            return createAssessmentTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentTemplateResult createAssessmentTemplate(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssessmentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssessmentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssessmentTemplateRequestMarshaller(this.protocolFactory).marshall((CreateAssessmentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAssessmentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAssessmentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssessmentTemplateResult createAssessmentTemplateResult = (CreateAssessmentTemplateResult)response.getAwsResponse();
            return createAssessmentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceGroupResult createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResourceGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResourceGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResourceGroupRequestMarshaller(this.protocolFactory).marshall((CreateResourceGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createResourceGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateResourceGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResourceGroupResult createResourceGroupResult = (CreateResourceGroupResult)response.getAwsResponse();
            return createResourceGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentRunResult deleteAssessmentRun(DeleteAssessmentRunRequest deleteAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentRunRequestMarshaller(this.protocolFactory).marshall((DeleteAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAssessmentRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssessmentRunResult deleteAssessmentRunResult = (DeleteAssessmentRunResult)response.getAwsResponse();
            return deleteAssessmentRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentTargetResult deleteAssessmentTarget(DeleteAssessmentTargetRequest deleteAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentTargetRequestMarshaller(this.protocolFactory).marshall((DeleteAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAssessmentTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssessmentTargetResult deleteAssessmentTargetResult = (DeleteAssessmentTargetResult)response.getAwsResponse();
            return deleteAssessmentTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentTemplateResult deleteAssessmentTemplate(DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentTemplateRequestMarshaller(this.protocolFactory).marshall((DeleteAssessmentTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssessmentTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAssessmentTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssessmentTemplateResult deleteAssessmentTemplateResult = (DeleteAssessmentTemplateResult)response.getAwsResponse();
            return deleteAssessmentTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentRunsResult describeAssessmentRuns(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentRunsRequestMarshaller(this.protocolFactory).marshall((DescribeAssessmentRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAssessmentRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssessmentRunsResult describeAssessmentRunsResult = (DescribeAssessmentRunsResult)response.getAwsResponse();
            return describeAssessmentRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTargetsResult describeAssessmentTargets(DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentTargetsRequestMarshaller(this.protocolFactory).marshall((DescribeAssessmentTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAssessmentTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssessmentTargetsResult describeAssessmentTargetsResult = (DescribeAssessmentTargetsResult)response.getAwsResponse();
            return describeAssessmentTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentTemplatesResult describeAssessmentTemplates(DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentTemplatesRequestMarshaller(this.protocolFactory).marshall((DescribeAssessmentTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssessmentTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAssessmentTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssessmentTemplatesResult describeAssessmentTemplatesResult = (DescribeAssessmentTemplatesResult)response.getAwsResponse();
            return describeAssessmentTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCrossAccountAccessRoleRequestMarshaller(this.protocolFactory).marshall((DescribeCrossAccountAccessRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeCrossAccountAccessRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeCrossAccountAccessRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRoleResult = (DescribeCrossAccountAccessRoleResult)response.getAwsResponse();
            return describeCrossAccountAccessRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFindingsResult describeFindings(DescribeFindingsRequest describeFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFindingsRequestMarshaller(this.protocolFactory).marshall((DescribeFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFindingsResult describeFindingsResult = (DescribeFindingsResult)response.getAwsResponse();
            return describeFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceGroupsResult describeResourceGroups(DescribeResourceGroupsRequest describeResourceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourceGroupsRequestMarshaller(this.protocolFactory).marshall((DescribeResourceGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeResourceGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeResourceGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeResourceGroupsResult describeResourceGroupsResult = (DescribeResourceGroupsResult)response.getAwsResponse();
            return describeResourceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRulesPackagesResult describeRulesPackages(DescribeRulesPackagesRequest describeRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRulesPackagesRequestMarshaller(this.protocolFactory).marshall((DescribeRulesPackagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRulesPackagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRulesPackagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRulesPackagesResult describeRulesPackagesResult = (DescribeRulesPackagesResult)response.getAwsResponse();
            return describeRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTelemetryMetadataResult getTelemetryMetadata(GetTelemetryMetadataRequest getTelemetryMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTelemetryMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTelemetryMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTelemetryMetadataRequestMarshaller(this.protocolFactory).marshall((GetTelemetryMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTelemetryMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTelemetryMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTelemetryMetadataResult getTelemetryMetadataResult = (GetTelemetryMetadataResult)response.getAwsResponse();
            return getTelemetryMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunAgentsResult listAssessmentRunAgents(ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentRunAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentRunAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentRunAgentsRequestMarshaller(this.protocolFactory).marshall((ListAssessmentRunAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentRunAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssessmentRunAgentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssessmentRunAgentsResult listAssessmentRunAgentsResult = (ListAssessmentRunAgentsResult)response.getAwsResponse();
            return listAssessmentRunAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentRunsResult listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentRunsRequestMarshaller(this.protocolFactory).marshall((ListAssessmentRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssessmentRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssessmentRunsResult listAssessmentRunsResult = (ListAssessmentRunsResult)response.getAwsResponse();
            return listAssessmentRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTargetsResult listAssessmentTargets(ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentTargetsRequestMarshaller(this.protocolFactory).marshall((ListAssessmentTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssessmentTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssessmentTargetsResult listAssessmentTargetsResult = (ListAssessmentTargetsResult)response.getAwsResponse();
            return listAssessmentTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentTemplatesResult listAssessmentTemplates(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentTemplatesRequestMarshaller(this.protocolFactory).marshall((ListAssessmentTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssessmentTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssessmentTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssessmentTemplatesResult listAssessmentTemplatesResult = (ListAssessmentTemplatesResult)response.getAwsResponse();
            return listAssessmentTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventSubscriptionsResult listEventSubscriptions(ListEventSubscriptionsRequest listEventSubscriptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventSubscriptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventSubscriptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventSubscriptionsRequestMarshaller(this.protocolFactory).marshall((ListEventSubscriptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventSubscriptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventSubscriptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventSubscriptionsResult listEventSubscriptionsResult = (ListEventSubscriptionsResult)response.getAwsResponse();
            return listEventSubscriptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResult listFindings(ListFindingsRequest listFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsRequestMarshaller(this.protocolFactory).marshall((ListFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingsResult listFindingsResult = (ListFindingsResult)response.getAwsResponse();
            return listFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesPackagesResult listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesPackagesRequestMarshaller(this.protocolFactory).marshall((ListRulesPackagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRulesPackagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRulesPackagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRulesPackagesResult listRulesPackagesResult = (ListRulesPackagesResult)response.getAwsResponse();
            return listRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestMarshaller(this.protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreviewAgentsResult previewAgents(PreviewAgentsRequest previewAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(previewAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PreviewAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PreviewAgentsRequestMarshaller(this.protocolFactory).marshall((PreviewAgentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)previewAgentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PreviewAgentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PreviewAgentsResult previewAgentsResult = (PreviewAgentsResult)response.getAwsResponse();
            return previewAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterCrossAccountAccessRoleResult registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterCrossAccountAccessRoleRequestMarshaller(this.protocolFactory).marshall((RegisterCrossAccountAccessRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerCrossAccountAccessRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterCrossAccountAccessRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterCrossAccountAccessRoleResult registerCrossAccountAccessRoleResult = (RegisterCrossAccountAccessRoleResult)response.getAwsResponse();
            return registerCrossAccountAccessRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAttributesFromFindingsResult removeAttributesFromFindings(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeAttributesFromFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveAttributesFromFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveAttributesFromFindingsRequestMarshaller(this.protocolFactory).marshall((RemoveAttributesFromFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeAttributesFromFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAttributesFromFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveAttributesFromFindingsResult removeAttributesFromFindingsResult = (RemoveAttributesFromFindingsResult)response.getAwsResponse();
            return removeAttributesFromFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTagsForResourceResult setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTagsForResourceRequestMarshaller(this.protocolFactory).marshall((SetTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)setTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetTagsForResourceResult setTagsForResourceResult = (SetTagsForResourceResult)response.getAwsResponse();
            return setTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAssessmentRunResult startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartAssessmentRunRequestMarshaller(this.protocolFactory).marshall((StartAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)startAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartAssessmentRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartAssessmentRunResult startAssessmentRunResult = (StartAssessmentRunResult)response.getAwsResponse();
            return startAssessmentRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopAssessmentRunResult stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopAssessmentRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopAssessmentRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopAssessmentRunRequestMarshaller(this.protocolFactory).marshall((StopAssessmentRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopAssessmentRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopAssessmentRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopAssessmentRunResult stopAssessmentRunResult = (StopAssessmentRunResult)response.getAwsResponse();
            return stopAssessmentRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeToEventResult subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeToEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeToEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeToEventRequestMarshaller(this.protocolFactory).marshall((SubscribeToEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)subscribeToEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubscribeToEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubscribeToEventResult subscribeToEventResult = (SubscribeToEventResult)response.getAwsResponse();
            return subscribeToEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeFromEventResult unsubscribeFromEvent(UnsubscribeFromEventRequest unsubscribeFromEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeFromEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeFromEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeFromEventRequestMarshaller(this.protocolFactory).marshall((UnsubscribeFromEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)unsubscribeFromEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnsubscribeFromEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnsubscribeFromEventResult unsubscribeFromEventResult = (UnsubscribeFromEventResult)response.getAwsResponse();
            return unsubscribeFromEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssessmentTargetResult updateAssessmentTarget(UpdateAssessmentTargetRequest updateAssessmentTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssessmentTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssessmentTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssessmentTargetRequestMarshaller(this.protocolFactory).marshall((UpdateAssessmentTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAssessmentTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAssessmentTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAssessmentTargetResult updateAssessmentTargetResult = (UpdateAssessmentTargetResult)response.getAwsResponse();
            return updateAssessmentTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

