/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class RemoveAttributesFromFindingsRequestMarshaller
implements Marshaller<Request<RemoveAttributesFromFindingsRequest>, RemoveAttributesFromFindingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RemoveAttributesFromFindingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemoveAttributesFromFindingsRequest> marshall(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        if (removeAttributesFromFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeAttributesFromFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.RemoveAttributesFromFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> attributeKeysList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> findingArnsList = removeAttributesFromFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonGenerator.writeFieldName("findingArns");
                jsonGenerator.writeStartArray();
                for (String string : findingArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((attributeKeysList = removeAttributesFromFindingsRequest.getAttributeKeys()) != null) {
                jsonGenerator.writeFieldName("attributeKeys");
                jsonGenerator.writeStartArray();
                for (String attributeKeysListValue : attributeKeysList) {
                    if (attributeKeysListValue == null) continue;
                    jsonGenerator.writeValue(attributeKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

