/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeAssessmentRunsRequestMarshaller
implements Marshaller<Request<DescribeAssessmentRunsRequest>, DescribeAssessmentRunsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAssessmentRunsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeAssessmentRunsRequest> marshall(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        if (describeAssessmentRunsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAssessmentRunsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeAssessmentRuns");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentRunArnsList = describeAssessmentRunsRequest.getAssessmentRunArns();
            if (assessmentRunArnsList != null) {
                jsonGenerator.writeFieldName("assessmentRunArns");
                jsonGenerator.writeStartArray();
                for (String assessmentRunArnsListValue : assessmentRunArnsList) {
                    if (assessmentRunArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentRunArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

