/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.AssessmentRun;
import com.amazonaws.services.inspector.model.AssessmentRunNotification;
import com.amazonaws.services.inspector.model.AssessmentRunStateChange;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AssessmentRunNotificationJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.AssessmentRunStateChangeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import java.util.List;

public class AssessmentRunJsonMarshaller {
    private static AssessmentRunJsonMarshaller instance;

    public void marshall(AssessmentRun assessmentRun, StructuredJsonGenerator jsonGenerator) {
        if (assessmentRun == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AssessmentRunNotification> notificationsList;
            List<AssessmentRunStateChange> stateChangesList;
            List<Attribute> userAttributesForFindingsList;
            List<String> rulesPackageArnsList;
            jsonGenerator.writeStartObject();
            if (assessmentRun.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(assessmentRun.getArn());
            }
            if (assessmentRun.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(assessmentRun.getName());
            }
            if (assessmentRun.getAssessmentTemplateArn() != null) {
                jsonGenerator.writeFieldName("assessmentTemplateArn").writeValue(assessmentRun.getAssessmentTemplateArn());
            }
            if (assessmentRun.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(assessmentRun.getState());
            }
            if (assessmentRun.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(assessmentRun.getDurationInSeconds().intValue());
            }
            if ((rulesPackageArnsList = assessmentRun.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesForFindingsList = assessmentRun.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (assessmentRun.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(assessmentRun.getCreatedAt());
            }
            if (assessmentRun.getStartedAt() != null) {
                jsonGenerator.writeFieldName("startedAt").writeValue(assessmentRun.getStartedAt());
            }
            if (assessmentRun.getCompletedAt() != null) {
                jsonGenerator.writeFieldName("completedAt").writeValue(assessmentRun.getCompletedAt());
            }
            if (assessmentRun.getStateChangedAt() != null) {
                jsonGenerator.writeFieldName("stateChangedAt").writeValue(assessmentRun.getStateChangedAt());
            }
            if (assessmentRun.getDataCollected() != null) {
                jsonGenerator.writeFieldName("dataCollected").writeValue(assessmentRun.getDataCollected().booleanValue());
            }
            if ((stateChangesList = assessmentRun.getStateChanges()) != null) {
                jsonGenerator.writeFieldName("stateChanges");
                jsonGenerator.writeStartArray();
                for (AssessmentRunStateChange stateChangesListValue : stateChangesList) {
                    if (stateChangesListValue == null) continue;
                    AssessmentRunStateChangeJsonMarshaller.getInstance().marshall(stateChangesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((notificationsList = assessmentRun.getNotifications()) != null) {
                jsonGenerator.writeFieldName("notifications");
                jsonGenerator.writeStartArray();
                for (AssessmentRunNotification notificationsListValue : notificationsList) {
                    if (notificationsListValue == null) continue;
                    AssessmentRunNotificationJsonMarshaller.getInstance().marshall(notificationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentRunJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentRunJsonMarshaller();
        }
        return instance;
    }
}

