/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ListAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentRunFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ListAssessmentRunsRequestMarshaller
implements Marshaller<Request<ListAssessmentRunsRequest>, ListAssessmentRunsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListAssessmentRunsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAssessmentRunsRequest> marshall(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        if (listAssessmentRunsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAssessmentRunsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessmentRuns");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentTemplateArnsList = listAssessmentRunsRequest.getAssessmentTemplateArns();
            if (assessmentTemplateArnsList != null) {
                jsonGenerator.writeFieldName("assessmentTemplateArns");
                jsonGenerator.writeStartArray();
                for (String assessmentTemplateArnsListValue : assessmentTemplateArnsList) {
                    if (assessmentTemplateArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentTemplateArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAssessmentRunsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentRunFilterJsonMarshaller.getInstance().marshall(listAssessmentRunsRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentRunsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentRunsRequest.getNextToken());
            }
            if (listAssessmentRunsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAssessmentRunsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

