/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentTargetFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListAssessmentTargetsRequestMarshaller
implements Marshaller<Request<ListAssessmentTargetsRequest>, ListAssessmentTargetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListAssessmentTargetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAssessmentTargetsRequest> marshall(ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        if (listAssessmentTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAssessmentTargetsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessmentTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listAssessmentTargetsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                AssessmentTargetFilterJsonMarshaller.getInstance().marshall(listAssessmentTargetsRequest.getFilter(), jsonGenerator);
            }
            if (listAssessmentTargetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAssessmentTargetsRequest.getNextToken());
            }
            if (listAssessmentTargetsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAssessmentTargetsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

