/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.ResourceGroup;
import com.amazonaws.services.inspector.model.ResourceGroupTag;
import com.amazonaws.services.inspector.model.transform.ResourceGroupTagJsonMarshaller;
import java.util.List;

public class ResourceGroupJsonMarshaller {
    private static ResourceGroupJsonMarshaller instance;

    public void marshall(ResourceGroup resourceGroup, StructuredJsonGenerator jsonGenerator) {
        if (resourceGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ResourceGroupTag> tagsList;
            jsonGenerator.writeStartObject();
            if (resourceGroup.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(resourceGroup.getArn());
            }
            if ((tagsList = resourceGroup.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (ResourceGroupTag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    ResourceGroupTagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (resourceGroup.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(resourceGroup.getCreatedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceGroupJsonMarshaller();
        }
        return instance;
    }
}

