/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a package vulnerability finding.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/PackageVulnerabilityDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PackageVulnerabilityDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     */
    private java.util.List<CvssScore> cvss;
    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     */
    private java.util.List<String> referenceUrls;
    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     */
    private java.util.List<String> relatedVulnerabilities;
    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     */
    private String source;
    /**
     * <p>
     * A URL to the source of the vulnerability information.
     * </p>
     */
    private String sourceUrl;
    /**
     * <p>
     * The date and time that this vulnerability was first added to the vendor's database.
     * </p>
     */
    private java.util.Date vendorCreatedAt;
    /**
     * <p>
     * The severity the vendor has given to this vulnerability type.
     * </p>
     */
    private String vendorSeverity;
    /**
     * <p>
     * The date and time the vendor last updated this vulnerability in their database.
     * </p>
     */
    private java.util.Date vendorUpdatedAt;
    /**
     * <p>
     * The ID given to this vulnerability.
     * </p>
     */
    private String vulnerabilityId;
    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     */
    private java.util.List<VulnerablePackage> vulnerablePackages;

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     * 
     * @return An object that contains details about the CVSS score of a finding.
     */

    public java.util.List<CvssScore> getCvss() {
        return cvss;
    }

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     * 
     * @param cvss
     *        An object that contains details about the CVSS score of a finding.
     */

    public void setCvss(java.util.Collection<CvssScore> cvss) {
        if (cvss == null) {
            this.cvss = null;
            return;
        }

        this.cvss = new java.util.ArrayList<CvssScore>(cvss);
    }

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCvss(java.util.Collection)} or {@link #withCvss(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param cvss
     *        An object that contains details about the CVSS score of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withCvss(CvssScore... cvss) {
        if (this.cvss == null) {
            setCvss(new java.util.ArrayList<CvssScore>(cvss.length));
        }
        for (CvssScore ele : cvss) {
            this.cvss.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     * 
     * @param cvss
     *        An object that contains details about the CVSS score of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withCvss(java.util.Collection<CvssScore> cvss) {
        setCvss(cvss);
        return this;
    }

    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     * 
     * @return One or more URLs that contain details about this vulnerability type.
     */

    public java.util.List<String> getReferenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URLs that contain details about this vulnerability type.
     */

    public void setReferenceUrls(java.util.Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }

        this.referenceUrls = new java.util.ArrayList<String>(referenceUrls);
    }

    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReferenceUrls(java.util.Collection)} or {@link #withReferenceUrls(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URLs that contain details about this vulnerability type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withReferenceUrls(String... referenceUrls) {
        if (this.referenceUrls == null) {
            setReferenceUrls(new java.util.ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URLs that contain details about this vulnerability type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withReferenceUrls(java.util.Collection<String> referenceUrls) {
        setReferenceUrls(referenceUrls);
        return this;
    }

    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     * 
     * @return One or more vulnerabilities related to the one identified in this finding.
     */

    public java.util.List<String> getRelatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities related to the one identified in this finding.
     */

    public void setRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }

        this.relatedVulnerabilities = new java.util.ArrayList<String>(relatedVulnerabilities);
    }

    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedVulnerabilities(java.util.Collection)} or
     * {@link #withRelatedVulnerabilities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities related to the one identified in this finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withRelatedVulnerabilities(String... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            setRelatedVulnerabilities(new java.util.ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities related to the one identified in this finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     * 
     * @param source
     *        The source of the vulnerability information.
     */

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     * 
     * @return The source of the vulnerability information.
     */

    public String getSource() {
        return this.source;
    }

    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     * 
     * @param source
     *        The source of the vulnerability information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withSource(String source) {
        setSource(source);
        return this;
    }

    /**
     * <p>
     * A URL to the source of the vulnerability information.
     * </p>
     * 
     * @param sourceUrl
     *        A URL to the source of the vulnerability information.
     */

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * <p>
     * A URL to the source of the vulnerability information.
     * </p>
     * 
     * @return A URL to the source of the vulnerability information.
     */

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * <p>
     * A URL to the source of the vulnerability information.
     * </p>
     * 
     * @param sourceUrl
     *        A URL to the source of the vulnerability information.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withSourceUrl(String sourceUrl) {
        setSourceUrl(sourceUrl);
        return this;
    }

    /**
     * <p>
     * The date and time that this vulnerability was first added to the vendor's database.
     * </p>
     * 
     * @param vendorCreatedAt
     *        The date and time that this vulnerability was first added to the vendor's database.
     */

    public void setVendorCreatedAt(java.util.Date vendorCreatedAt) {
        this.vendorCreatedAt = vendorCreatedAt;
    }

    /**
     * <p>
     * The date and time that this vulnerability was first added to the vendor's database.
     * </p>
     * 
     * @return The date and time that this vulnerability was first added to the vendor's database.
     */

    public java.util.Date getVendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    /**
     * <p>
     * The date and time that this vulnerability was first added to the vendor's database.
     * </p>
     * 
     * @param vendorCreatedAt
     *        The date and time that this vulnerability was first added to the vendor's database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVendorCreatedAt(java.util.Date vendorCreatedAt) {
        setVendorCreatedAt(vendorCreatedAt);
        return this;
    }

    /**
     * <p>
     * The severity the vendor has given to this vulnerability type.
     * </p>
     * 
     * @param vendorSeverity
     *        The severity the vendor has given to this vulnerability type.
     */

    public void setVendorSeverity(String vendorSeverity) {
        this.vendorSeverity = vendorSeverity;
    }

    /**
     * <p>
     * The severity the vendor has given to this vulnerability type.
     * </p>
     * 
     * @return The severity the vendor has given to this vulnerability type.
     */

    public String getVendorSeverity() {
        return this.vendorSeverity;
    }

    /**
     * <p>
     * The severity the vendor has given to this vulnerability type.
     * </p>
     * 
     * @param vendorSeverity
     *        The severity the vendor has given to this vulnerability type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVendorSeverity(String vendorSeverity) {
        setVendorSeverity(vendorSeverity);
        return this;
    }

    /**
     * <p>
     * The date and time the vendor last updated this vulnerability in their database.
     * </p>
     * 
     * @param vendorUpdatedAt
     *        The date and time the vendor last updated this vulnerability in their database.
     */

    public void setVendorUpdatedAt(java.util.Date vendorUpdatedAt) {
        this.vendorUpdatedAt = vendorUpdatedAt;
    }

    /**
     * <p>
     * The date and time the vendor last updated this vulnerability in their database.
     * </p>
     * 
     * @return The date and time the vendor last updated this vulnerability in their database.
     */

    public java.util.Date getVendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    /**
     * <p>
     * The date and time the vendor last updated this vulnerability in their database.
     * </p>
     * 
     * @param vendorUpdatedAt
     *        The date and time the vendor last updated this vulnerability in their database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVendorUpdatedAt(java.util.Date vendorUpdatedAt) {
        setVendorUpdatedAt(vendorUpdatedAt);
        return this;
    }

    /**
     * <p>
     * The ID given to this vulnerability.
     * </p>
     * 
     * @param vulnerabilityId
     *        The ID given to this vulnerability.
     */

    public void setVulnerabilityId(String vulnerabilityId) {
        this.vulnerabilityId = vulnerabilityId;
    }

    /**
     * <p>
     * The ID given to this vulnerability.
     * </p>
     * 
     * @return The ID given to this vulnerability.
     */

    public String getVulnerabilityId() {
        return this.vulnerabilityId;
    }

    /**
     * <p>
     * The ID given to this vulnerability.
     * </p>
     * 
     * @param vulnerabilityId
     *        The ID given to this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVulnerabilityId(String vulnerabilityId) {
        setVulnerabilityId(vulnerabilityId);
        return this;
    }

    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     * 
     * @return The packages impacted by this vulnerability.
     */

    public java.util.List<VulnerablePackage> getVulnerablePackages() {
        return vulnerablePackages;
    }

    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     * 
     * @param vulnerablePackages
     *        The packages impacted by this vulnerability.
     */

    public void setVulnerablePackages(java.util.Collection<VulnerablePackage> vulnerablePackages) {
        if (vulnerablePackages == null) {
            this.vulnerablePackages = null;
            return;
        }

        this.vulnerablePackages = new java.util.ArrayList<VulnerablePackage>(vulnerablePackages);
    }

    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setVulnerablePackages(java.util.Collection)} or {@link #withVulnerablePackages(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param vulnerablePackages
     *        The packages impacted by this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVulnerablePackages(VulnerablePackage... vulnerablePackages) {
        if (this.vulnerablePackages == null) {
            setVulnerablePackages(new java.util.ArrayList<VulnerablePackage>(vulnerablePackages.length));
        }
        for (VulnerablePackage ele : vulnerablePackages) {
            this.vulnerablePackages.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     * 
     * @param vulnerablePackages
     *        The packages impacted by this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PackageVulnerabilityDetails withVulnerablePackages(java.util.Collection<VulnerablePackage> vulnerablePackages) {
        setVulnerablePackages(vulnerablePackages);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCvss() != null)
            sb.append("Cvss: ").append(getCvss()).append(",");
        if (getReferenceUrls() != null)
            sb.append("ReferenceUrls: ").append(getReferenceUrls()).append(",");
        if (getRelatedVulnerabilities() != null)
            sb.append("RelatedVulnerabilities: ").append(getRelatedVulnerabilities()).append(",");
        if (getSource() != null)
            sb.append("Source: ").append(getSource()).append(",");
        if (getSourceUrl() != null)
            sb.append("SourceUrl: ").append(getSourceUrl()).append(",");
        if (getVendorCreatedAt() != null)
            sb.append("VendorCreatedAt: ").append(getVendorCreatedAt()).append(",");
        if (getVendorSeverity() != null)
            sb.append("VendorSeverity: ").append(getVendorSeverity()).append(",");
        if (getVendorUpdatedAt() != null)
            sb.append("VendorUpdatedAt: ").append(getVendorUpdatedAt()).append(",");
        if (getVulnerabilityId() != null)
            sb.append("VulnerabilityId: ").append(getVulnerabilityId()).append(",");
        if (getVulnerablePackages() != null)
            sb.append("VulnerablePackages: ").append(getVulnerablePackages());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PackageVulnerabilityDetails == false)
            return false;
        PackageVulnerabilityDetails other = (PackageVulnerabilityDetails) obj;
        if (other.getCvss() == null ^ this.getCvss() == null)
            return false;
        if (other.getCvss() != null && other.getCvss().equals(this.getCvss()) == false)
            return false;
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null)
            return false;
        if (other.getReferenceUrls() != null && other.getReferenceUrls().equals(this.getReferenceUrls()) == false)
            return false;
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null)
            return false;
        if (other.getRelatedVulnerabilities() != null && other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities()) == false)
            return false;
        if (other.getSource() == null ^ this.getSource() == null)
            return false;
        if (other.getSource() != null && other.getSource().equals(this.getSource()) == false)
            return false;
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null)
            return false;
        if (other.getSourceUrl() != null && other.getSourceUrl().equals(this.getSourceUrl()) == false)
            return false;
        if (other.getVendorCreatedAt() == null ^ this.getVendorCreatedAt() == null)
            return false;
        if (other.getVendorCreatedAt() != null && other.getVendorCreatedAt().equals(this.getVendorCreatedAt()) == false)
            return false;
        if (other.getVendorSeverity() == null ^ this.getVendorSeverity() == null)
            return false;
        if (other.getVendorSeverity() != null && other.getVendorSeverity().equals(this.getVendorSeverity()) == false)
            return false;
        if (other.getVendorUpdatedAt() == null ^ this.getVendorUpdatedAt() == null)
            return false;
        if (other.getVendorUpdatedAt() != null && other.getVendorUpdatedAt().equals(this.getVendorUpdatedAt()) == false)
            return false;
        if (other.getVulnerabilityId() == null ^ this.getVulnerabilityId() == null)
            return false;
        if (other.getVulnerabilityId() != null && other.getVulnerabilityId().equals(this.getVulnerabilityId()) == false)
            return false;
        if (other.getVulnerablePackages() == null ^ this.getVulnerablePackages() == null)
            return false;
        if (other.getVulnerablePackages() != null && other.getVulnerablePackages().equals(this.getVulnerablePackages()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCvss() == null) ? 0 : getCvss().hashCode());
        hashCode = prime * hashCode + ((getReferenceUrls() == null) ? 0 : getReferenceUrls().hashCode());
        hashCode = prime * hashCode + ((getRelatedVulnerabilities() == null) ? 0 : getRelatedVulnerabilities().hashCode());
        hashCode = prime * hashCode + ((getSource() == null) ? 0 : getSource().hashCode());
        hashCode = prime * hashCode + ((getSourceUrl() == null) ? 0 : getSourceUrl().hashCode());
        hashCode = prime * hashCode + ((getVendorCreatedAt() == null) ? 0 : getVendorCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getVendorSeverity() == null) ? 0 : getVendorSeverity().hashCode());
        hashCode = prime * hashCode + ((getVendorUpdatedAt() == null) ? 0 : getVendorUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getVulnerabilityId() == null) ? 0 : getVulnerabilityId().hashCode());
        hashCode = prime * hashCode + ((getVulnerablePackages() == null) ? 0 : getVulnerablePackages().hashCode());
        return hashCode;
    }

    @Override
    public PackageVulnerabilityDetails clone() {
        try {
            return (PackageVulnerabilityDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.inspector2.model.transform.PackageVulnerabilityDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
