/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains details about a specific vulnerability Amazon Inspector can detect.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Vulnerability" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Vulnerability implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the
     * vulnerability.
     * </p>
     */
    private AtigData atigData;
    /**
     * <p>
     * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     * vulnerability.
     * </p>
     */
    private CisaData cisaData;
    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
     * </p>
     */
    private Cvss2 cvss2;
    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
     * </p>
     */
    private Cvss3 cvss3;
    /**
     * <p>
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * </p>
     */
    private java.util.List<String> cwes;
    /**
     * <p>
     * A description of the vulnerability.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Platforms that the vulnerability can be detected on.
     * </p>
     */
    private java.util.List<String> detectionPlatforms;
    /**
     * <p>
     * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     * </p>
     */
    private Epss epss;
    /**
     * <p>
     * An object that contains details on when the exploit was observed.
     * </p>
     */
    private ExploitObserved exploitObserved;
    /**
     * <p>
     * The ID for the specific vulnerability.
     * </p>
     */
    private String id;
    /**
     * <p>
     * Links to various resources with more information on this vulnerability.
     * </p>
     */
    private java.util.List<String> referenceUrls;
    /**
     * <p>
     * A list of related vulnerabilities.
     * </p>
     */
    private java.util.List<String> relatedVulnerabilities;
    /**
     * <p>
     * The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>,
     * <code>DEBIAN</code> or <code>NVD</code>.
     * </p>
     */
    private String source;
    /**
     * <p>
     * A link to the official source material for this vulnerability.
     * </p>
     */
    private String sourceUrl;
    /**
     * <p>
     * The date and time when the vendor created this vulnerability.
     * </p>
     */
    private java.util.Date vendorCreatedAt;
    /**
     * <p>
     * The severity assigned by the vendor.
     * </p>
     */
    private String vendorSeverity;
    /**
     * <p>
     * The date and time when the vendor last updated this vulnerability.
     * </p>
     */
    private java.util.Date vendorUpdatedAt;

    /**
     * <p>
     * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the
     * vulnerability.
     * </p>
     * 
     * @param atigData
     *        An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for
     *        the vulnerability.
     */

    public void setAtigData(AtigData atigData) {
        this.atigData = atigData;
    }

    /**
     * <p>
     * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the
     * vulnerability.
     * </p>
     * 
     * @return An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for
     *         the vulnerability.
     */

    public AtigData getAtigData() {
        return this.atigData;
    }

    /**
     * <p>
     * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the
     * vulnerability.
     * </p>
     * 
     * @param atigData
     *        An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for
     *        the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withAtigData(AtigData atigData) {
        setAtigData(atigData);
        return this;
    }

    /**
     * <p>
     * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     * vulnerability.
     * </p>
     * 
     * @param cisaData
     *        An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     *        vulnerability.
     */

    public void setCisaData(CisaData cisaData) {
        this.cisaData = cisaData;
    }

    /**
     * <p>
     * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     * vulnerability.
     * </p>
     * 
     * @return An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     *         vulnerability.
     */

    public CisaData getCisaData() {
        return this.cisaData;
    }

    /**
     * <p>
     * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     * vulnerability.
     * </p>
     * 
     * @param cisaData
     *        An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the
     *        vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCisaData(CisaData cisaData) {
        setCisaData(cisaData);
        return this;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
     * </p>
     * 
     * @param cvss2
     *        An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the
     *        vulnerability.
     */

    public void setCvss2(Cvss2 cvss2) {
        this.cvss2 = cvss2;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
     * </p>
     * 
     * @return An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the
     *         vulnerability.
     */

    public Cvss2 getCvss2() {
        return this.cvss2;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
     * </p>
     * 
     * @param cvss2
     *        An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the
     *        vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCvss2(Cvss2 cvss2) {
        setCvss2(cvss2);
        return this;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
     * </p>
     * 
     * @param cvss3
     *        An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the
     *        vulnerability.
     */

    public void setCvss3(Cvss3 cvss3) {
        this.cvss3 = cvss3;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
     * </p>
     * 
     * @return An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the
     *         vulnerability.
     */

    public Cvss3 getCvss3() {
        return this.cvss3;
    }

    /**
     * <p>
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
     * </p>
     * 
     * @param cvss3
     *        An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the
     *        vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCvss3(Cvss3 cvss3) {
        setCvss3(cvss3);
        return this;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * </p>
     * 
     * @return The Common Weakness Enumeration (CWE) associated with the vulnerability.
     */

    public java.util.List<String> getCwes() {
        return cwes;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) associated with the vulnerability.
     */

    public void setCwes(java.util.Collection<String> cwes) {
        if (cwes == null) {
            this.cwes = null;
            return;
        }

        this.cwes = new java.util.ArrayList<String>(cwes);
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCwes(java.util.Collection)} or {@link #withCwes(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCwes(String... cwes) {
        if (this.cwes == null) {
            setCwes(new java.util.ArrayList<String>(cwes.length));
        }
        for (String ele : cwes) {
            this.cwes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * </p>
     * 
     * @param cwes
     *        The Common Weakness Enumeration (CWE) associated with the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withCwes(java.util.Collection<String> cwes) {
        setCwes(cwes);
        return this;
    }

    /**
     * <p>
     * A description of the vulnerability.
     * </p>
     * 
     * @param description
     *        A description of the vulnerability.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the vulnerability.
     * </p>
     * 
     * @return A description of the vulnerability.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the vulnerability.
     * </p>
     * 
     * @param description
     *        A description of the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Platforms that the vulnerability can be detected on.
     * </p>
     * 
     * @return Platforms that the vulnerability can be detected on.
     */

    public java.util.List<String> getDetectionPlatforms() {
        return detectionPlatforms;
    }

    /**
     * <p>
     * Platforms that the vulnerability can be detected on.
     * </p>
     * 
     * @param detectionPlatforms
     *        Platforms that the vulnerability can be detected on.
     */

    public void setDetectionPlatforms(java.util.Collection<String> detectionPlatforms) {
        if (detectionPlatforms == null) {
            this.detectionPlatforms = null;
            return;
        }

        this.detectionPlatforms = new java.util.ArrayList<String>(detectionPlatforms);
    }

    /**
     * <p>
     * Platforms that the vulnerability can be detected on.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDetectionPlatforms(java.util.Collection)} or {@link #withDetectionPlatforms(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param detectionPlatforms
     *        Platforms that the vulnerability can be detected on.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withDetectionPlatforms(String... detectionPlatforms) {
        if (this.detectionPlatforms == null) {
            setDetectionPlatforms(new java.util.ArrayList<String>(detectionPlatforms.length));
        }
        for (String ele : detectionPlatforms) {
            this.detectionPlatforms.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Platforms that the vulnerability can be detected on.
     * </p>
     * 
     * @param detectionPlatforms
     *        Platforms that the vulnerability can be detected on.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withDetectionPlatforms(java.util.Collection<String> detectionPlatforms) {
        setDetectionPlatforms(detectionPlatforms);
        return this;
    }

    /**
     * <p>
     * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     * </p>
     * 
     * @param epss
     *        An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     */

    public void setEpss(Epss epss) {
        this.epss = epss;
    }

    /**
     * <p>
     * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     * </p>
     * 
     * @return An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     */

    public Epss getEpss() {
        return this.epss;
    }

    /**
     * <p>
     * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     * </p>
     * 
     * @param epss
     *        An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withEpss(Epss epss) {
        setEpss(epss);
        return this;
    }

    /**
     * <p>
     * An object that contains details on when the exploit was observed.
     * </p>
     * 
     * @param exploitObserved
     *        An object that contains details on when the exploit was observed.
     */

    public void setExploitObserved(ExploitObserved exploitObserved) {
        this.exploitObserved = exploitObserved;
    }

    /**
     * <p>
     * An object that contains details on when the exploit was observed.
     * </p>
     * 
     * @return An object that contains details on when the exploit was observed.
     */

    public ExploitObserved getExploitObserved() {
        return this.exploitObserved;
    }

    /**
     * <p>
     * An object that contains details on when the exploit was observed.
     * </p>
     * 
     * @param exploitObserved
     *        An object that contains details on when the exploit was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withExploitObserved(ExploitObserved exploitObserved) {
        setExploitObserved(exploitObserved);
        return this;
    }

    /**
     * <p>
     * The ID for the specific vulnerability.
     * </p>
     * 
     * @param id
     *        The ID for the specific vulnerability.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The ID for the specific vulnerability.
     * </p>
     * 
     * @return The ID for the specific vulnerability.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The ID for the specific vulnerability.
     * </p>
     * 
     * @param id
     *        The ID for the specific vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * Links to various resources with more information on this vulnerability.
     * </p>
     * 
     * @return Links to various resources with more information on this vulnerability.
     */

    public java.util.List<String> getReferenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * Links to various resources with more information on this vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        Links to various resources with more information on this vulnerability.
     */

    public void setReferenceUrls(java.util.Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }

        this.referenceUrls = new java.util.ArrayList<String>(referenceUrls);
    }

    /**
     * <p>
     * Links to various resources with more information on this vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReferenceUrls(java.util.Collection)} or {@link #withReferenceUrls(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param referenceUrls
     *        Links to various resources with more information on this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(String... referenceUrls) {
        if (this.referenceUrls == null) {
            setReferenceUrls(new java.util.ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Links to various resources with more information on this vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        Links to various resources with more information on this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(java.util.Collection<String> referenceUrls) {
        setReferenceUrls(referenceUrls);
        return this;
    }

    /**
     * <p>
     * A list of related vulnerabilities.
     * </p>
     * 
     * @return A list of related vulnerabilities.
     */

    public java.util.List<String> getRelatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * A list of related vulnerabilities.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        A list of related vulnerabilities.
     */

    public void setRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }

        this.relatedVulnerabilities = new java.util.ArrayList<String>(relatedVulnerabilities);
    }

    /**
     * <p>
     * A list of related vulnerabilities.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedVulnerabilities(java.util.Collection)} or
     * {@link #withRelatedVulnerabilities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        A list of related vulnerabilities.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(String... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            setRelatedVulnerabilities(new java.util.ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of related vulnerabilities.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        A list of related vulnerabilities.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    /**
     * <p>
     * The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>,
     * <code>DEBIAN</code> or <code>NVD</code>.
     * </p>
     * 
     * @param source
     *        The source of the vulnerability information. Possible results are <code>RHEL</code>,
     *        <code>AMAZON_CVE</code>, <code>DEBIAN</code> or <code>NVD</code>.
     * @see VulnerabilitySource
     */

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * <p>
     * The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>,
     * <code>DEBIAN</code> or <code>NVD</code>.
     * </p>
     * 
     * @return The source of the vulnerability information. Possible results are <code>RHEL</code>,
     *         <code>AMAZON_CVE</code>, <code>DEBIAN</code> or <code>NVD</code>.
     * @see VulnerabilitySource
     */

    public String getSource() {
        return this.source;
    }

    /**
     * <p>
     * The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>,
     * <code>DEBIAN</code> or <code>NVD</code>.
     * </p>
     * 
     * @param source
     *        The source of the vulnerability information. Possible results are <code>RHEL</code>,
     *        <code>AMAZON_CVE</code>, <code>DEBIAN</code> or <code>NVD</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VulnerabilitySource
     */

    public Vulnerability withSource(String source) {
        setSource(source);
        return this;
    }

    /**
     * <p>
     * The source of the vulnerability information. Possible results are <code>RHEL</code>, <code>AMAZON_CVE</code>,
     * <code>DEBIAN</code> or <code>NVD</code>.
     * </p>
     * 
     * @param source
     *        The source of the vulnerability information. Possible results are <code>RHEL</code>,
     *        <code>AMAZON_CVE</code>, <code>DEBIAN</code> or <code>NVD</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VulnerabilitySource
     */

    public Vulnerability withSource(VulnerabilitySource source) {
        this.source = source.toString();
        return this;
    }

    /**
     * <p>
     * A link to the official source material for this vulnerability.
     * </p>
     * 
     * @param sourceUrl
     *        A link to the official source material for this vulnerability.
     */

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * <p>
     * A link to the official source material for this vulnerability.
     * </p>
     * 
     * @return A link to the official source material for this vulnerability.
     */

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * <p>
     * A link to the official source material for this vulnerability.
     * </p>
     * 
     * @param sourceUrl
     *        A link to the official source material for this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withSourceUrl(String sourceUrl) {
        setSourceUrl(sourceUrl);
        return this;
    }

    /**
     * <p>
     * The date and time when the vendor created this vulnerability.
     * </p>
     * 
     * @param vendorCreatedAt
     *        The date and time when the vendor created this vulnerability.
     */

    public void setVendorCreatedAt(java.util.Date vendorCreatedAt) {
        this.vendorCreatedAt = vendorCreatedAt;
    }

    /**
     * <p>
     * The date and time when the vendor created this vulnerability.
     * </p>
     * 
     * @return The date and time when the vendor created this vulnerability.
     */

    public java.util.Date getVendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    /**
     * <p>
     * The date and time when the vendor created this vulnerability.
     * </p>
     * 
     * @param vendorCreatedAt
     *        The date and time when the vendor created this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVendorCreatedAt(java.util.Date vendorCreatedAt) {
        setVendorCreatedAt(vendorCreatedAt);
        return this;
    }

    /**
     * <p>
     * The severity assigned by the vendor.
     * </p>
     * 
     * @param vendorSeverity
     *        The severity assigned by the vendor.
     */

    public void setVendorSeverity(String vendorSeverity) {
        this.vendorSeverity = vendorSeverity;
    }

    /**
     * <p>
     * The severity assigned by the vendor.
     * </p>
     * 
     * @return The severity assigned by the vendor.
     */

    public String getVendorSeverity() {
        return this.vendorSeverity;
    }

    /**
     * <p>
     * The severity assigned by the vendor.
     * </p>
     * 
     * @param vendorSeverity
     *        The severity assigned by the vendor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVendorSeverity(String vendorSeverity) {
        setVendorSeverity(vendorSeverity);
        return this;
    }

    /**
     * <p>
     * The date and time when the vendor last updated this vulnerability.
     * </p>
     * 
     * @param vendorUpdatedAt
     *        The date and time when the vendor last updated this vulnerability.
     */

    public void setVendorUpdatedAt(java.util.Date vendorUpdatedAt) {
        this.vendorUpdatedAt = vendorUpdatedAt;
    }

    /**
     * <p>
     * The date and time when the vendor last updated this vulnerability.
     * </p>
     * 
     * @return The date and time when the vendor last updated this vulnerability.
     */

    public java.util.Date getVendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    /**
     * <p>
     * The date and time when the vendor last updated this vulnerability.
     * </p>
     * 
     * @param vendorUpdatedAt
     *        The date and time when the vendor last updated this vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withVendorUpdatedAt(java.util.Date vendorUpdatedAt) {
        setVendorUpdatedAt(vendorUpdatedAt);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAtigData() != null)
            sb.append("AtigData: ").append(getAtigData()).append(",");
        if (getCisaData() != null)
            sb.append("CisaData: ").append(getCisaData()).append(",");
        if (getCvss2() != null)
            sb.append("Cvss2: ").append(getCvss2()).append(",");
        if (getCvss3() != null)
            sb.append("Cvss3: ").append(getCvss3()).append(",");
        if (getCwes() != null)
            sb.append("Cwes: ").append(getCwes()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getDetectionPlatforms() != null)
            sb.append("DetectionPlatforms: ").append(getDetectionPlatforms()).append(",");
        if (getEpss() != null)
            sb.append("Epss: ").append(getEpss()).append(",");
        if (getExploitObserved() != null)
            sb.append("ExploitObserved: ").append(getExploitObserved()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getReferenceUrls() != null)
            sb.append("ReferenceUrls: ").append(getReferenceUrls()).append(",");
        if (getRelatedVulnerabilities() != null)
            sb.append("RelatedVulnerabilities: ").append(getRelatedVulnerabilities()).append(",");
        if (getSource() != null)
            sb.append("Source: ").append(getSource()).append(",");
        if (getSourceUrl() != null)
            sb.append("SourceUrl: ").append(getSourceUrl()).append(",");
        if (getVendorCreatedAt() != null)
            sb.append("VendorCreatedAt: ").append(getVendorCreatedAt()).append(",");
        if (getVendorSeverity() != null)
            sb.append("VendorSeverity: ").append(getVendorSeverity()).append(",");
        if (getVendorUpdatedAt() != null)
            sb.append("VendorUpdatedAt: ").append(getVendorUpdatedAt());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Vulnerability == false)
            return false;
        Vulnerability other = (Vulnerability) obj;
        if (other.getAtigData() == null ^ this.getAtigData() == null)
            return false;
        if (other.getAtigData() != null && other.getAtigData().equals(this.getAtigData()) == false)
            return false;
        if (other.getCisaData() == null ^ this.getCisaData() == null)
            return false;
        if (other.getCisaData() != null && other.getCisaData().equals(this.getCisaData()) == false)
            return false;
        if (other.getCvss2() == null ^ this.getCvss2() == null)
            return false;
        if (other.getCvss2() != null && other.getCvss2().equals(this.getCvss2()) == false)
            return false;
        if (other.getCvss3() == null ^ this.getCvss3() == null)
            return false;
        if (other.getCvss3() != null && other.getCvss3().equals(this.getCvss3()) == false)
            return false;
        if (other.getCwes() == null ^ this.getCwes() == null)
            return false;
        if (other.getCwes() != null && other.getCwes().equals(this.getCwes()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getDetectionPlatforms() == null ^ this.getDetectionPlatforms() == null)
            return false;
        if (other.getDetectionPlatforms() != null && other.getDetectionPlatforms().equals(this.getDetectionPlatforms()) == false)
            return false;
        if (other.getEpss() == null ^ this.getEpss() == null)
            return false;
        if (other.getEpss() != null && other.getEpss().equals(this.getEpss()) == false)
            return false;
        if (other.getExploitObserved() == null ^ this.getExploitObserved() == null)
            return false;
        if (other.getExploitObserved() != null && other.getExploitObserved().equals(this.getExploitObserved()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null)
            return false;
        if (other.getReferenceUrls() != null && other.getReferenceUrls().equals(this.getReferenceUrls()) == false)
            return false;
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null)
            return false;
        if (other.getRelatedVulnerabilities() != null && other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities()) == false)
            return false;
        if (other.getSource() == null ^ this.getSource() == null)
            return false;
        if (other.getSource() != null && other.getSource().equals(this.getSource()) == false)
            return false;
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null)
            return false;
        if (other.getSourceUrl() != null && other.getSourceUrl().equals(this.getSourceUrl()) == false)
            return false;
        if (other.getVendorCreatedAt() == null ^ this.getVendorCreatedAt() == null)
            return false;
        if (other.getVendorCreatedAt() != null && other.getVendorCreatedAt().equals(this.getVendorCreatedAt()) == false)
            return false;
        if (other.getVendorSeverity() == null ^ this.getVendorSeverity() == null)
            return false;
        if (other.getVendorSeverity() != null && other.getVendorSeverity().equals(this.getVendorSeverity()) == false)
            return false;
        if (other.getVendorUpdatedAt() == null ^ this.getVendorUpdatedAt() == null)
            return false;
        if (other.getVendorUpdatedAt() != null && other.getVendorUpdatedAt().equals(this.getVendorUpdatedAt()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAtigData() == null) ? 0 : getAtigData().hashCode());
        hashCode = prime * hashCode + ((getCisaData() == null) ? 0 : getCisaData().hashCode());
        hashCode = prime * hashCode + ((getCvss2() == null) ? 0 : getCvss2().hashCode());
        hashCode = prime * hashCode + ((getCvss3() == null) ? 0 : getCvss3().hashCode());
        hashCode = prime * hashCode + ((getCwes() == null) ? 0 : getCwes().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getDetectionPlatforms() == null) ? 0 : getDetectionPlatforms().hashCode());
        hashCode = prime * hashCode + ((getEpss() == null) ? 0 : getEpss().hashCode());
        hashCode = prime * hashCode + ((getExploitObserved() == null) ? 0 : getExploitObserved().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getReferenceUrls() == null) ? 0 : getReferenceUrls().hashCode());
        hashCode = prime * hashCode + ((getRelatedVulnerabilities() == null) ? 0 : getRelatedVulnerabilities().hashCode());
        hashCode = prime * hashCode + ((getSource() == null) ? 0 : getSource().hashCode());
        hashCode = prime * hashCode + ((getSourceUrl() == null) ? 0 : getSourceUrl().hashCode());
        hashCode = prime * hashCode + ((getVendorCreatedAt() == null) ? 0 : getVendorCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getVendorSeverity() == null) ? 0 : getVendorSeverity().hashCode());
        hashCode = prime * hashCode + ((getVendorUpdatedAt() == null) ? 0 : getVendorUpdatedAt().hashCode());
        return hashCode;
    }

    @Override
    public Vulnerability clone() {
        try {
            return (Vulnerability) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.inspector2.model.transform.VulnerabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
