/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.AtigData;
import com.amazonaws.services.inspector2.model.CisaData;
import com.amazonaws.services.inspector2.model.Cvss2;
import com.amazonaws.services.inspector2.model.Cvss3;
import com.amazonaws.services.inspector2.model.Epss;
import com.amazonaws.services.inspector2.model.ExploitObserved;
import com.amazonaws.services.inspector2.model.VulnerabilitySource;
import com.amazonaws.services.inspector2.model.transform.VulnerabilityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Vulnerability
implements Serializable,
Cloneable,
StructuredPojo {
    private AtigData atigData;
    private CisaData cisaData;
    private Cvss2 cvss2;
    private Cvss3 cvss3;
    private List<String> cwes;
    private String description;
    private List<String> detectionPlatforms;
    private Epss epss;
    private ExploitObserved exploitObserved;
    private String id;
    private List<String> referenceUrls;
    private List<String> relatedVulnerabilities;
    private String source;
    private String sourceUrl;
    private Date vendorCreatedAt;
    private String vendorSeverity;
    private Date vendorUpdatedAt;

    public void setAtigData(AtigData atigData) {
        this.atigData = atigData;
    }

    public AtigData getAtigData() {
        return this.atigData;
    }

    public Vulnerability withAtigData(AtigData atigData) {
        this.setAtigData(atigData);
        return this;
    }

    public void setCisaData(CisaData cisaData) {
        this.cisaData = cisaData;
    }

    public CisaData getCisaData() {
        return this.cisaData;
    }

    public Vulnerability withCisaData(CisaData cisaData) {
        this.setCisaData(cisaData);
        return this;
    }

    public void setCvss2(Cvss2 cvss2) {
        this.cvss2 = cvss2;
    }

    public Cvss2 getCvss2() {
        return this.cvss2;
    }

    public Vulnerability withCvss2(Cvss2 cvss2) {
        this.setCvss2(cvss2);
        return this;
    }

    public void setCvss3(Cvss3 cvss3) {
        this.cvss3 = cvss3;
    }

    public Cvss3 getCvss3() {
        return this.cvss3;
    }

    public Vulnerability withCvss3(Cvss3 cvss3) {
        this.setCvss3(cvss3);
        return this;
    }

    public List<String> getCwes() {
        return this.cwes;
    }

    public void setCwes(Collection<String> cwes) {
        if (cwes == null) {
            this.cwes = null;
            return;
        }
        this.cwes = new ArrayList<String>(cwes);
    }

    public Vulnerability withCwes(String ... cwes) {
        if (this.cwes == null) {
            this.setCwes(new ArrayList<String>(cwes.length));
        }
        for (String ele : cwes) {
            this.cwes.add(ele);
        }
        return this;
    }

    public Vulnerability withCwes(Collection<String> cwes) {
        this.setCwes(cwes);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Vulnerability withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getDetectionPlatforms() {
        return this.detectionPlatforms;
    }

    public void setDetectionPlatforms(Collection<String> detectionPlatforms) {
        if (detectionPlatforms == null) {
            this.detectionPlatforms = null;
            return;
        }
        this.detectionPlatforms = new ArrayList<String>(detectionPlatforms);
    }

    public Vulnerability withDetectionPlatforms(String ... detectionPlatforms) {
        if (this.detectionPlatforms == null) {
            this.setDetectionPlatforms(new ArrayList<String>(detectionPlatforms.length));
        }
        for (String ele : detectionPlatforms) {
            this.detectionPlatforms.add(ele);
        }
        return this;
    }

    public Vulnerability withDetectionPlatforms(Collection<String> detectionPlatforms) {
        this.setDetectionPlatforms(detectionPlatforms);
        return this;
    }

    public void setEpss(Epss epss) {
        this.epss = epss;
    }

    public Epss getEpss() {
        return this.epss;
    }

    public Vulnerability withEpss(Epss epss) {
        this.setEpss(epss);
        return this;
    }

    public void setExploitObserved(ExploitObserved exploitObserved) {
        this.exploitObserved = exploitObserved;
    }

    public ExploitObserved getExploitObserved() {
        return this.exploitObserved;
    }

    public Vulnerability withExploitObserved(ExploitObserved exploitObserved) {
        this.setExploitObserved(exploitObserved);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Vulnerability withId(String id) {
        this.setId(id);
        return this;
    }

    public List<String> getReferenceUrls() {
        return this.referenceUrls;
    }

    public void setReferenceUrls(Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }
        this.referenceUrls = new ArrayList<String>(referenceUrls);
    }

    public Vulnerability withReferenceUrls(String ... referenceUrls) {
        if (this.referenceUrls == null) {
            this.setReferenceUrls(new ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    public Vulnerability withReferenceUrls(Collection<String> referenceUrls) {
        this.setReferenceUrls(referenceUrls);
        return this;
    }

    public List<String> getRelatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }
        this.relatedVulnerabilities = new ArrayList<String>(relatedVulnerabilities);
    }

    public Vulnerability withRelatedVulnerabilities(String ... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            this.setRelatedVulnerabilities(new ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    public Vulnerability withRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        this.setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Vulnerability withSource(String source) {
        this.setSource(source);
        return this;
    }

    public Vulnerability withSource(VulnerabilitySource source) {
        this.source = source.toString();
        return this;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public Vulnerability withSourceUrl(String sourceUrl) {
        this.setSourceUrl(sourceUrl);
        return this;
    }

    public void setVendorCreatedAt(Date vendorCreatedAt) {
        this.vendorCreatedAt = vendorCreatedAt;
    }

    public Date getVendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    public Vulnerability withVendorCreatedAt(Date vendorCreatedAt) {
        this.setVendorCreatedAt(vendorCreatedAt);
        return this;
    }

    public void setVendorSeverity(String vendorSeverity) {
        this.vendorSeverity = vendorSeverity;
    }

    public String getVendorSeverity() {
        return this.vendorSeverity;
    }

    public Vulnerability withVendorSeverity(String vendorSeverity) {
        this.setVendorSeverity(vendorSeverity);
        return this;
    }

    public void setVendorUpdatedAt(Date vendorUpdatedAt) {
        this.vendorUpdatedAt = vendorUpdatedAt;
    }

    public Date getVendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    public Vulnerability withVendorUpdatedAt(Date vendorUpdatedAt) {
        this.setVendorUpdatedAt(vendorUpdatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAtigData() != null) {
            sb.append("AtigData: ").append(this.getAtigData()).append(",");
        }
        if (this.getCisaData() != null) {
            sb.append("CisaData: ").append(this.getCisaData()).append(",");
        }
        if (this.getCvss2() != null) {
            sb.append("Cvss2: ").append(this.getCvss2()).append(",");
        }
        if (this.getCvss3() != null) {
            sb.append("Cvss3: ").append(this.getCvss3()).append(",");
        }
        if (this.getCwes() != null) {
            sb.append("Cwes: ").append(this.getCwes()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDetectionPlatforms() != null) {
            sb.append("DetectionPlatforms: ").append(this.getDetectionPlatforms()).append(",");
        }
        if (this.getEpss() != null) {
            sb.append("Epss: ").append(this.getEpss()).append(",");
        }
        if (this.getExploitObserved() != null) {
            sb.append("ExploitObserved: ").append(this.getExploitObserved()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getReferenceUrls() != null) {
            sb.append("ReferenceUrls: ").append(this.getReferenceUrls()).append(",");
        }
        if (this.getRelatedVulnerabilities() != null) {
            sb.append("RelatedVulnerabilities: ").append(this.getRelatedVulnerabilities()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getSourceUrl() != null) {
            sb.append("SourceUrl: ").append(this.getSourceUrl()).append(",");
        }
        if (this.getVendorCreatedAt() != null) {
            sb.append("VendorCreatedAt: ").append(this.getVendorCreatedAt()).append(",");
        }
        if (this.getVendorSeverity() != null) {
            sb.append("VendorSeverity: ").append(this.getVendorSeverity()).append(",");
        }
        if (this.getVendorUpdatedAt() != null) {
            sb.append("VendorUpdatedAt: ").append(this.getVendorUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        if (other.getAtigData() == null ^ this.getAtigData() == null) {
            return false;
        }
        if (other.getAtigData() != null && !other.getAtigData().equals(this.getAtigData())) {
            return false;
        }
        if (other.getCisaData() == null ^ this.getCisaData() == null) {
            return false;
        }
        if (other.getCisaData() != null && !other.getCisaData().equals(this.getCisaData())) {
            return false;
        }
        if (other.getCvss2() == null ^ this.getCvss2() == null) {
            return false;
        }
        if (other.getCvss2() != null && !other.getCvss2().equals(this.getCvss2())) {
            return false;
        }
        if (other.getCvss3() == null ^ this.getCvss3() == null) {
            return false;
        }
        if (other.getCvss3() != null && !other.getCvss3().equals(this.getCvss3())) {
            return false;
        }
        if (other.getCwes() == null ^ this.getCwes() == null) {
            return false;
        }
        if (other.getCwes() != null && !other.getCwes().equals(this.getCwes())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDetectionPlatforms() == null ^ this.getDetectionPlatforms() == null) {
            return false;
        }
        if (other.getDetectionPlatforms() != null && !other.getDetectionPlatforms().equals(this.getDetectionPlatforms())) {
            return false;
        }
        if (other.getEpss() == null ^ this.getEpss() == null) {
            return false;
        }
        if (other.getEpss() != null && !other.getEpss().equals(this.getEpss())) {
            return false;
        }
        if (other.getExploitObserved() == null ^ this.getExploitObserved() == null) {
            return false;
        }
        if (other.getExploitObserved() != null && !other.getExploitObserved().equals(this.getExploitObserved())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null) {
            return false;
        }
        if (other.getReferenceUrls() != null && !other.getReferenceUrls().equals(this.getReferenceUrls())) {
            return false;
        }
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null) {
            return false;
        }
        if (other.getRelatedVulnerabilities() != null && !other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null) {
            return false;
        }
        if (other.getSourceUrl() != null && !other.getSourceUrl().equals(this.getSourceUrl())) {
            return false;
        }
        if (other.getVendorCreatedAt() == null ^ this.getVendorCreatedAt() == null) {
            return false;
        }
        if (other.getVendorCreatedAt() != null && !other.getVendorCreatedAt().equals(this.getVendorCreatedAt())) {
            return false;
        }
        if (other.getVendorSeverity() == null ^ this.getVendorSeverity() == null) {
            return false;
        }
        if (other.getVendorSeverity() != null && !other.getVendorSeverity().equals(this.getVendorSeverity())) {
            return false;
        }
        if (other.getVendorUpdatedAt() == null ^ this.getVendorUpdatedAt() == null) {
            return false;
        }
        return other.getVendorUpdatedAt() == null || other.getVendorUpdatedAt().equals(this.getVendorUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAtigData() == null ? 0 : this.getAtigData().hashCode());
        hashCode = 31 * hashCode + (this.getCisaData() == null ? 0 : this.getCisaData().hashCode());
        hashCode = 31 * hashCode + (this.getCvss2() == null ? 0 : this.getCvss2().hashCode());
        hashCode = 31 * hashCode + (this.getCvss3() == null ? 0 : this.getCvss3().hashCode());
        hashCode = 31 * hashCode + (this.getCwes() == null ? 0 : this.getCwes().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDetectionPlatforms() == null ? 0 : this.getDetectionPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getEpss() == null ? 0 : this.getEpss().hashCode());
        hashCode = 31 * hashCode + (this.getExploitObserved() == null ? 0 : this.getExploitObserved().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceUrls() == null ? 0 : this.getReferenceUrls().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedVulnerabilities() == null ? 0 : this.getRelatedVulnerabilities().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getSourceUrl() == null ? 0 : this.getSourceUrl().hashCode());
        hashCode = 31 * hashCode + (this.getVendorCreatedAt() == null ? 0 : this.getVendorCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getVendorSeverity() == null ? 0 : this.getVendorSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getVendorUpdatedAt() == null ? 0 : this.getVendorUpdatedAt().hashCode());
        return hashCode;
    }

    public Vulnerability clone() {
        try {
            return (Vulnerability)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VulnerabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

