/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.inspector2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * PackageVulnerabilityDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class PackageVulnerabilityDetailsMarshaller {

    private static final MarshallingInfo<List> CVSS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cvss").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("referenceUrls").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedVulnerabilities").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("source").build();
    private static final MarshallingInfo<String> SOURCEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("sourceUrl").build();
    private static final MarshallingInfo<java.util.Date> VENDORCREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorCreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VENDORSEVERITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorSeverity").build();
    private static final MarshallingInfo<java.util.Date> VENDORUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VULNERABILITYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vulnerabilityId").build();
    private static final MarshallingInfo<List> VULNERABLEPACKAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vulnerablePackages").build();

    private static final PackageVulnerabilityDetailsMarshaller instance = new PackageVulnerabilityDetailsMarshaller();

    public static PackageVulnerabilityDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(PackageVulnerabilityDetails packageVulnerabilityDetails, ProtocolMarshaller protocolMarshaller) {

        if (packageVulnerabilityDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(packageVulnerabilityDetails.getCvss(), CVSS_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getSourceUrl(), SOURCEURL_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVendorCreatedAt(), VENDORCREATEDAT_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVendorSeverity(), VENDORSEVERITY_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVendorUpdatedAt(), VENDORUPDATEDAT_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVulnerabilityId(), VULNERABILITYID_BINDING);
            protocolMarshaller.marshall(packageVulnerabilityDetails.getVulnerablePackages(), VULNERABLEPACKAGES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
