/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.internetmonitor.model.InternetEventSummary;
import java.util.Date;

@SdkInternalApi
public class InternetEventSummaryMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventId").build();
    private static final MarshallingInfo<String> EVENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventArn").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> CLIENTLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientLocation").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventType").build();
    private static final MarshallingInfo<String> EVENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventStatus").build();
    private static final InternetEventSummaryMarshaller instance = new InternetEventSummaryMarshaller();

    public static InternetEventSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(InternetEventSummary internetEventSummary, ProtocolMarshaller protocolMarshaller) {
        if (internetEventSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)internetEventSummary.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getEventArn(), EVENTARN_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getStartedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getEndedAt(), ENDEDAT_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getClientLocation(), CLIENTLOCATION_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)internetEventSummary.getEventStatus(), EVENTSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

