/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.KeyPair;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class KeyPairJsonMarshaller {
    private static KeyPairJsonMarshaller instance;

    public void marshall(KeyPair keyPair, StructuredJsonGenerator jsonGenerator) {
        if (keyPair == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyPair.getPublicKey() != null) {
                jsonGenerator.writeFieldName("PublicKey").writeValue(keyPair.getPublicKey());
            }
            if (keyPair.getPrivateKey() != null) {
                jsonGenerator.writeFieldName("PrivateKey").writeValue(keyPair.getPrivateKey());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyPairJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairJsonMarshaller();
        }
        return instance;
    }
}

