/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTargetsForPolicyResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<String> targets;
    private String nextMarker;

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<String> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<String>(targets);
    }

    public ListTargetsForPolicyResult withTargets(String ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<String>(targets.length));
        }
        for (String ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public ListTargetsForPolicyResult withTargets(Collection<String> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListTargetsForPolicyResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResult)) {
            return false;
        }
        ListTargetsForPolicyResult other = (ListTargetsForPolicyResult)obj;
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public ListTargetsForPolicyResult clone() {
        try {
            return (ListTargetsForPolicyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

