/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot1clickdevices;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot1clickdevices.AWSIoT1ClickDevices;
import com.amazonaws.services.iot1clickdevices.AWSIoT1ClickDevicesClientBuilder;
import com.amazonaws.services.iot1clickdevices.model.AWSIoT1ClickDevicesException;
import com.amazonaws.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import com.amazonaws.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResult;
import com.amazonaws.services.iot1clickdevices.model.DescribeDeviceRequest;
import com.amazonaws.services.iot1clickdevices.model.DescribeDeviceResult;
import com.amazonaws.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import com.amazonaws.services.iot1clickdevices.model.FinalizeDeviceClaimResult;
import com.amazonaws.services.iot1clickdevices.model.ForbiddenException;
import com.amazonaws.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import com.amazonaws.services.iot1clickdevices.model.GetDeviceMethodsResult;
import com.amazonaws.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import com.amazonaws.services.iot1clickdevices.model.InitiateDeviceClaimResult;
import com.amazonaws.services.iot1clickdevices.model.InternalFailureException;
import com.amazonaws.services.iot1clickdevices.model.InvalidRequestException;
import com.amazonaws.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import com.amazonaws.services.iot1clickdevices.model.InvokeDeviceMethodResult;
import com.amazonaws.services.iot1clickdevices.model.ListDeviceEventsRequest;
import com.amazonaws.services.iot1clickdevices.model.ListDeviceEventsResult;
import com.amazonaws.services.iot1clickdevices.model.ListDevicesRequest;
import com.amazonaws.services.iot1clickdevices.model.ListDevicesResult;
import com.amazonaws.services.iot1clickdevices.model.ListTagsForResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.ListTagsForResourceResult;
import com.amazonaws.services.iot1clickdevices.model.PreconditionFailedException;
import com.amazonaws.services.iot1clickdevices.model.RangeNotSatisfiableException;
import com.amazonaws.services.iot1clickdevices.model.ResourceConflictException;
import com.amazonaws.services.iot1clickdevices.model.ResourceNotFoundException;
import com.amazonaws.services.iot1clickdevices.model.TagResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.TagResourceResult;
import com.amazonaws.services.iot1clickdevices.model.UnclaimDeviceRequest;
import com.amazonaws.services.iot1clickdevices.model.UnclaimDeviceResult;
import com.amazonaws.services.iot1clickdevices.model.UntagResourceRequest;
import com.amazonaws.services.iot1clickdevices.model.UntagResourceResult;
import com.amazonaws.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import com.amazonaws.services.iot1clickdevices.model.UpdateDeviceStateResult;
import com.amazonaws.services.iot1clickdevices.model.transform.ClaimDevicesByClaimCodeRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ClaimDevicesByClaimCodeResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.DescribeDeviceRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.DescribeDeviceResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.FinalizeDeviceClaimRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.FinalizeDeviceClaimResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.GetDeviceMethodsRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.GetDeviceMethodsResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.InitiateDeviceClaimRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.InitiateDeviceClaimResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.InvokeDeviceMethodRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.InvokeDeviceMethodResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListDeviceEventsRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListDeviceEventsResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListDevicesRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListDevicesResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UnclaimDeviceRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UnclaimDeviceResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UpdateDeviceStateRequestProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.transform.UpdateDeviceStateResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoT1ClickDevicesClient
extends AmazonWebServiceClient
implements AWSIoT1ClickDevices {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoT1ClickDevices.class);
    private static final String DEFAULT_SIGNING_NAME = "iot1click";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PreconditionFailedException").withModeledClass(PreconditionFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RangeNotSatisfiableException").withModeledClass(RangeNotSatisfiableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflictException").withModeledClass(ResourceConflictException.class)).withBaseServiceExceptionClass(AWSIoT1ClickDevicesException.class));

    public static AWSIoT1ClickDevicesClientBuilder builder() {
        return AWSIoT1ClickDevicesClientBuilder.standard();
    }

    AWSIoT1ClickDevicesClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoT1ClickDevicesClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("devices.iot1click");
        this.setEndpoint("devices.iot1click.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iot1clickdevices/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iot1clickdevices/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public ClaimDevicesByClaimCodeResult claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest request) {
        request = (ClaimDevicesByClaimCodeRequest)this.beforeClientExecution(request);
        return this.executeClaimDevicesByClaimCode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ClaimDevicesByClaimCodeResult executeClaimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest claimDevicesByClaimCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(claimDevicesByClaimCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ClaimDevicesByClaimCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ClaimDevicesByClaimCodeRequestProtocolMarshaller(protocolFactory).marshall((ClaimDevicesByClaimCodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)claimDevicesByClaimCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ClaimDevicesByClaimCode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ClaimDevicesByClaimCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ClaimDevicesByClaimCodeResult claimDevicesByClaimCodeResult = (ClaimDevicesByClaimCodeResult)response.getAwsResponse();
            return claimDevicesByClaimCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDeviceResult describeDevice(DescribeDeviceRequest request) {
        request = (DescribeDeviceRequest)this.beforeClientExecution(request);
        return this.executeDescribeDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDeviceResult executeDescribeDevice(DescribeDeviceRequest describeDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDeviceRequestProtocolMarshaller(protocolFactory).marshall((DescribeDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDeviceResult describeDeviceResult = (DescribeDeviceResult)response.getAwsResponse();
            return describeDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public FinalizeDeviceClaimResult finalizeDeviceClaim(FinalizeDeviceClaimRequest request) {
        request = (FinalizeDeviceClaimRequest)this.beforeClientExecution(request);
        return this.executeFinalizeDeviceClaim(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final FinalizeDeviceClaimResult executeFinalizeDeviceClaim(FinalizeDeviceClaimRequest finalizeDeviceClaimRequest) {
        ExecutionContext executionContext = this.createExecutionContext(finalizeDeviceClaimRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<FinalizeDeviceClaimRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new FinalizeDeviceClaimRequestProtocolMarshaller(protocolFactory).marshall((FinalizeDeviceClaimRequest)super.beforeMarshalling((AmazonWebServiceRequest)finalizeDeviceClaimRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"FinalizeDeviceClaim");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new FinalizeDeviceClaimResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            FinalizeDeviceClaimResult finalizeDeviceClaimResult = (FinalizeDeviceClaimResult)response.getAwsResponse();
            return finalizeDeviceClaimResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDeviceMethodsResult getDeviceMethods(GetDeviceMethodsRequest request) {
        request = (GetDeviceMethodsRequest)this.beforeClientExecution(request);
        return this.executeGetDeviceMethods(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDeviceMethodsResult executeGetDeviceMethods(GetDeviceMethodsRequest getDeviceMethodsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDeviceMethodsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDeviceMethodsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDeviceMethodsRequestProtocolMarshaller(protocolFactory).marshall((GetDeviceMethodsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDeviceMethodsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDeviceMethods");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDeviceMethodsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDeviceMethodsResult getDeviceMethodsResult = (GetDeviceMethodsResult)response.getAwsResponse();
            return getDeviceMethodsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitiateDeviceClaimResult initiateDeviceClaim(InitiateDeviceClaimRequest request) {
        request = (InitiateDeviceClaimRequest)this.beforeClientExecution(request);
        return this.executeInitiateDeviceClaim(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitiateDeviceClaimResult executeInitiateDeviceClaim(InitiateDeviceClaimRequest initiateDeviceClaimRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateDeviceClaimRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateDeviceClaimRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateDeviceClaimRequestProtocolMarshaller(protocolFactory).marshall((InitiateDeviceClaimRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateDeviceClaimRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InitiateDeviceClaim");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateDeviceClaimResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateDeviceClaimResult initiateDeviceClaimResult = (InitiateDeviceClaimResult)response.getAwsResponse();
            return initiateDeviceClaimResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InvokeDeviceMethodResult invokeDeviceMethod(InvokeDeviceMethodRequest request) {
        request = (InvokeDeviceMethodRequest)this.beforeClientExecution(request);
        return this.executeInvokeDeviceMethod(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InvokeDeviceMethodResult executeInvokeDeviceMethod(InvokeDeviceMethodRequest invokeDeviceMethodRequest) {
        ExecutionContext executionContext = this.createExecutionContext(invokeDeviceMethodRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InvokeDeviceMethodRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InvokeDeviceMethodRequestProtocolMarshaller(protocolFactory).marshall((InvokeDeviceMethodRequest)super.beforeMarshalling((AmazonWebServiceRequest)invokeDeviceMethodRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InvokeDeviceMethod");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeDeviceMethodResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InvokeDeviceMethodResult invokeDeviceMethodResult = (InvokeDeviceMethodResult)response.getAwsResponse();
            return invokeDeviceMethodResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDeviceEventsResult listDeviceEvents(ListDeviceEventsRequest request) {
        request = (ListDeviceEventsRequest)this.beforeClientExecution(request);
        return this.executeListDeviceEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeviceEventsResult executeListDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeviceEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeviceEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeviceEventsRequestProtocolMarshaller(protocolFactory).marshall((ListDeviceEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeviceEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeviceEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeviceEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeviceEventsResult listDeviceEventsResult = (ListDeviceEventsResult)response.getAwsResponse();
            return listDeviceEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDevicesResult listDevices(ListDevicesRequest request) {
        request = (ListDevicesRequest)this.beforeClientExecution(request);
        return this.executeListDevices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDevicesResult executeListDevices(ListDevicesRequest listDevicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDevicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDevicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDevicesRequestProtocolMarshaller(protocolFactory).marshall((ListDevicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDevicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDevices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDevicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDevicesResult listDevicesResult = (ListDevicesResult)response.getAwsResponse();
            return listDevicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnclaimDeviceResult unclaimDevice(UnclaimDeviceRequest request) {
        request = (UnclaimDeviceRequest)this.beforeClientExecution(request);
        return this.executeUnclaimDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnclaimDeviceResult executeUnclaimDevice(UnclaimDeviceRequest unclaimDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unclaimDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnclaimDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnclaimDeviceRequestProtocolMarshaller(protocolFactory).marshall((UnclaimDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)unclaimDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UnclaimDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnclaimDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnclaimDeviceResult unclaimDeviceResult = (UnclaimDeviceResult)response.getAwsResponse();
            return unclaimDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDeviceStateResult updateDeviceState(UpdateDeviceStateRequest request) {
        request = (UpdateDeviceStateRequest)this.beforeClientExecution(request);
        return this.executeUpdateDeviceState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDeviceStateResult executeUpdateDeviceState(UpdateDeviceStateRequest updateDeviceStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDeviceStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDeviceStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDeviceStateRequestProtocolMarshaller(protocolFactory).marshall((UpdateDeviceStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDeviceStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT 1Click Devices Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDeviceState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDeviceStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDeviceStateResult updateDeviceStateResult = (UpdateDeviceStateResult)response.getAwsResponse();
            return updateDeviceStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

