/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.DatasetAction;
import com.amazonaws.services.iotanalytics.model.DatasetTrigger;
import com.amazonaws.services.iotanalytics.model.RetentionPeriod;
import com.amazonaws.services.iotanalytics.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDatasetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String datasetName;
    private List<DatasetAction> actions;
    private List<DatasetTrigger> triggers;
    private RetentionPeriod retentionPeriod;
    private List<Tag> tags;

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public CreateDatasetRequest withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public List<DatasetAction> getActions() {
        return this.actions;
    }

    public void setActions(Collection<DatasetAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<DatasetAction>(actions);
    }

    public CreateDatasetRequest withActions(DatasetAction ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<DatasetAction>(actions.length));
        }
        for (DatasetAction ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateDatasetRequest withActions(Collection<DatasetAction> actions) {
        this.setActions(actions);
        return this;
    }

    public List<DatasetTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<DatasetTrigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        this.triggers = new ArrayList<DatasetTrigger>(triggers);
    }

    public CreateDatasetRequest withTriggers(DatasetTrigger ... triggers) {
        if (this.triggers == null) {
            this.setTriggers(new ArrayList<DatasetTrigger>(triggers.length));
        }
        for (DatasetTrigger ele : triggers) {
            this.triggers.add(ele);
        }
        return this;
    }

    public CreateDatasetRequest withTriggers(Collection<DatasetTrigger> triggers) {
        this.setTriggers(triggers);
        return this;
    }

    public void setRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public RetentionPeriod getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public CreateDatasetRequest withRetentionPeriod(RetentionPeriod retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDatasetRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDatasetRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: ").append(this.getTriggers()).append(",");
        }
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)obj;
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        if (other.getTriggers() != null && !other.getTriggers().equals(this.getTriggers())) {
            return false;
        }
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : this.getTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateDatasetRequest clone() {
        return (CreateDatasetRequest)super.clone();
    }
}

