/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.iotanalytics.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DatastoreSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DatastoreSummaryJsonUnmarshaller implements Unmarshaller<DatastoreSummary, JsonUnmarshallerContext> {

    public DatastoreSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        DatastoreSummary datastoreSummary = new DatastoreSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("datastoreName", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setDatastoreName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("datastoreStorage", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setDatastoreStorage(DatastoreStorageSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setCreationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastUpdateTime", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setLastUpdateTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastMessageArrivalTime", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setLastMessageArrivalTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("fileFormatType", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setFileFormatType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("datastorePartitions", targetDepth)) {
                    context.nextToken();
                    datastoreSummary.setDatastorePartitions(DatastorePartitionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return datastoreSummary;
    }

    private static DatastoreSummaryJsonUnmarshaller instance;

    public static DatastoreSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DatastoreSummaryJsonUnmarshaller();
        return instance;
    }
}
