/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotevents.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information required to publish the Amazon SNS message.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/SNSTopicPublishAction" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SNSTopicPublishAction implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ARN of the Amazon SNS target where the message is sent.
     * </p>
     */
    private String targetArn;
    /**
     * <p>
     * You can configure the action payload when you send a message as an Amazon SNS push notification.
     * </p>
     */
    private Payload payload;

    /**
     * <p>
     * The ARN of the Amazon SNS target where the message is sent.
     * </p>
     * 
     * @param targetArn
     *        The ARN of the Amazon SNS target where the message is sent.
     */

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    /**
     * <p>
     * The ARN of the Amazon SNS target where the message is sent.
     * </p>
     * 
     * @return The ARN of the Amazon SNS target where the message is sent.
     */

    public String getTargetArn() {
        return this.targetArn;
    }

    /**
     * <p>
     * The ARN of the Amazon SNS target where the message is sent.
     * </p>
     * 
     * @param targetArn
     *        The ARN of the Amazon SNS target where the message is sent.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SNSTopicPublishAction withTargetArn(String targetArn) {
        setTargetArn(targetArn);
        return this;
    }

    /**
     * <p>
     * You can configure the action payload when you send a message as an Amazon SNS push notification.
     * </p>
     * 
     * @param payload
     *        You can configure the action payload when you send a message as an Amazon SNS push notification.
     */

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    /**
     * <p>
     * You can configure the action payload when you send a message as an Amazon SNS push notification.
     * </p>
     * 
     * @return You can configure the action payload when you send a message as an Amazon SNS push notification.
     */

    public Payload getPayload() {
        return this.payload;
    }

    /**
     * <p>
     * You can configure the action payload when you send a message as an Amazon SNS push notification.
     * </p>
     * 
     * @param payload
     *        You can configure the action payload when you send a message as an Amazon SNS push notification.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SNSTopicPublishAction withPayload(Payload payload) {
        setPayload(payload);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTargetArn() != null)
            sb.append("TargetArn: ").append(getTargetArn()).append(",");
        if (getPayload() != null)
            sb.append("Payload: ").append(getPayload());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SNSTopicPublishAction == false)
            return false;
        SNSTopicPublishAction other = (SNSTopicPublishAction) obj;
        if (other.getTargetArn() == null ^ this.getTargetArn() == null)
            return false;
        if (other.getTargetArn() != null && other.getTargetArn().equals(this.getTargetArn()) == false)
            return false;
        if (other.getPayload() == null ^ this.getPayload() == null)
            return false;
        if (other.getPayload() != null && other.getPayload().equals(this.getPayload()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTargetArn() == null) ? 0 : getTargetArn().hashCode());
        hashCode = prime * hashCode + ((getPayload() == null) ? 0 : getPayload().hashCode());
        return hashCode;
    }

    @Override
    public SNSTopicPublishAction clone() {
        try {
            return (SNSTopicPublishAction) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotevents.model.transform.SNSTopicPublishActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
