/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotfleetwise.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/ListFleets" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListFleetsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of information for each fleet.
     * </p>
     */
    private java.util.List<FleetSummary> fleetSummaries;
    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of information for each fleet.
     * </p>
     * 
     * @return A list of information for each fleet.
     */

    public java.util.List<FleetSummary> getFleetSummaries() {
        return fleetSummaries;
    }

    /**
     * <p>
     * A list of information for each fleet.
     * </p>
     * 
     * @param fleetSummaries
     *        A list of information for each fleet.
     */

    public void setFleetSummaries(java.util.Collection<FleetSummary> fleetSummaries) {
        if (fleetSummaries == null) {
            this.fleetSummaries = null;
            return;
        }

        this.fleetSummaries = new java.util.ArrayList<FleetSummary>(fleetSummaries);
    }

    /**
     * <p>
     * A list of information for each fleet.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFleetSummaries(java.util.Collection)} or {@link #withFleetSummaries(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param fleetSummaries
     *        A list of information for each fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFleetsResult withFleetSummaries(FleetSummary... fleetSummaries) {
        if (this.fleetSummaries == null) {
            setFleetSummaries(new java.util.ArrayList<FleetSummary>(fleetSummaries.length));
        }
        for (FleetSummary ele : fleetSummaries) {
            this.fleetSummaries.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of information for each fleet.
     * </p>
     * 
     * @param fleetSummaries
     *        A list of information for each fleet.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFleetsResult withFleetSummaries(java.util.Collection<FleetSummary> fleetSummaries) {
        setFleetSummaries(fleetSummaries);
        return this;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @param nextToken
     *        The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @param nextToken
     *        The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFleetsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFleetSummaries() != null)
            sb.append("FleetSummaries: ").append(getFleetSummaries()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListFleetsResult == false)
            return false;
        ListFleetsResult other = (ListFleetsResult) obj;
        if (other.getFleetSummaries() == null ^ this.getFleetSummaries() == null)
            return false;
        if (other.getFleetSummaries() != null && other.getFleetSummaries().equals(this.getFleetSummaries()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFleetSummaries() == null) ? 0 : getFleetSummaries().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListFleetsResult clone() {
        try {
            return (ListFleetsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
