/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotthingsgraph;

import javax.annotation.Generated;

import com.amazonaws.services.iotthingsgraph.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTThingsGraph}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTThingsGraph implements AWSIoTThingsGraph {

    protected AbstractAWSIoTThingsGraph() {
    }

    @Override
    public AssociateEntityToThingResult associateEntityToThing(AssociateEntityToThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowTemplateResult createFlowTemplate(CreateFlowTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSystemInstanceResult createSystemInstance(CreateSystemInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSystemTemplateResult createSystemTemplate(CreateSystemTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowTemplateResult deleteFlowTemplate(DeleteFlowTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSystemInstanceResult deleteSystemInstance(DeleteSystemInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSystemTemplateResult deleteSystemTemplate(DeleteSystemTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeploySystemInstanceResult deploySystemInstance(DeploySystemInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeprecateFlowTemplateResult deprecateFlowTemplate(DeprecateFlowTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeprecateSystemTemplateResult deprecateSystemTemplate(DeprecateSystemTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNamespaceResult describeNamespace(DescribeNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DissociateEntityFromThingResult dissociateEntityFromThing(DissociateEntityFromThingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEntitiesResult getEntities(GetEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFlowTemplateResult getFlowTemplate(GetFlowTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFlowTemplateRevisionsResult getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNamespaceDeletionStatusResult getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSystemInstanceResult getSystemInstance(GetSystemInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSystemTemplateResult getSystemTemplate(GetSystemTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSystemTemplateRevisionsResult getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUploadStatusResult getUploadStatus(GetUploadStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowExecutionMessagesResult listFlowExecutionMessages(ListFlowExecutionMessagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchEntitiesResult searchEntities(SearchEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchFlowExecutionsResult searchFlowExecutions(SearchFlowExecutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchFlowTemplatesResult searchFlowTemplates(SearchFlowTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchSystemInstancesResult searchSystemInstances(SearchSystemInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchSystemTemplatesResult searchSystemTemplates(SearchSystemTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchThingsResult searchThings(SearchThingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UndeploySystemInstanceResult undeploySystemInstance(UndeploySystemInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFlowTemplateResult updateFlowTemplate(UpdateFlowTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSystemTemplateResult updateSystemTemplate(UpdateSystemTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UploadEntityDefinitionsResult uploadEntityDefinitions(UploadEntityDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
