/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataValue;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class DataValueMarshaller {
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("booleanValue").build();
    private static final MarshallingInfo<Double> DOUBLEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("doubleValue").build();
    private static final MarshallingInfo<Integer> INTEGERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("integerValue").build();
    private static final MarshallingInfo<Long> LONGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("longValue").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").build();
    private static final MarshallingInfo<List> LISTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("listValue").build();
    private static final MarshallingInfo<Map> MAPVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mapValue").build();
    private static final MarshallingInfo<StructuredPojo> RELATIONSHIPVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relationshipValue").build();
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expression").build();
    private static final DataValueMarshaller instance = new DataValueMarshaller();

    public static DataValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataValue dataValue, ProtocolMarshaller protocolMarshaller) {
        if (dataValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataValue.getBooleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getDoubleValue(), DOUBLEVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getIntegerValue(), INTEGERVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getLongValue(), LONGVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getStringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall(dataValue.getListValue(), LISTVALUE_BINDING);
            protocolMarshaller.marshall(dataValue.getMapValue(), MAPVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getRelationshipValue(), RELATIONSHIPVALUE_BINDING);
            protocolMarshaller.marshall((Object)dataValue.getExpression(), EXPRESSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

