/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Message delivery status resource type event configuration object for enabling or disabling relevant topic.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/MessageDeliveryStatusResourceTypeEventConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MessageDeliveryStatusResourceTypeEventConfiguration implements Serializable, Cloneable, StructuredPojo {

    private SidewalkResourceTypeEventConfiguration sidewalk;

    /**
     * @param sidewalk
     */

    public void setSidewalk(SidewalkResourceTypeEventConfiguration sidewalk) {
        this.sidewalk = sidewalk;
    }

    /**
     * @return
     */

    public SidewalkResourceTypeEventConfiguration getSidewalk() {
        return this.sidewalk;
    }

    /**
     * @param sidewalk
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MessageDeliveryStatusResourceTypeEventConfiguration withSidewalk(SidewalkResourceTypeEventConfiguration sidewalk) {
        setSidewalk(sidewalk);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSidewalk() != null)
            sb.append("Sidewalk: ").append(getSidewalk());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MessageDeliveryStatusResourceTypeEventConfiguration == false)
            return false;
        MessageDeliveryStatusResourceTypeEventConfiguration other = (MessageDeliveryStatusResourceTypeEventConfiguration) obj;
        if (other.getSidewalk() == null ^ this.getSidewalk() == null)
            return false;
        if (other.getSidewalk() != null && other.getSidewalk().equals(this.getSidewalk()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSidewalk() == null) ? 0 : getSidewalk().hashCode());
        return hashCode;
    }

    @Override
    public MessageDeliveryStatusResourceTypeEventConfiguration clone() {
        try {
            return (MessageDeliveryStatusResourceTypeEventConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotwireless.model.transform.MessageDeliveryStatusResourceTypeEventConfigurationMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
