/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.iotwireless.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * LoRaWANGateway JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LoRaWANGatewayJsonUnmarshaller implements Unmarshaller<LoRaWANGateway, JsonUnmarshallerContext> {

    public LoRaWANGateway unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoRaWANGateway loRaWANGateway = new LoRaWANGateway();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("GatewayEui", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setGatewayEui(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RfRegion", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setRfRegion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("JoinEuiFilters", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setJoinEuiFilters(new ListUnmarshaller<java.util.List<String>>(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class))

                    )

                    .unmarshall(context));
                }
                if (context.testExpression("NetIdFilters", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setNetIdFilters(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("SubBands", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setSubBands(new ListUnmarshaller<Integer>(context.getUnmarshaller(Integer.class))

                    .unmarshall(context));
                }
                if (context.testExpression("Beaconing", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setBeaconing(BeaconingJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxEirp", targetDepth)) {
                    context.nextToken();
                    loRaWANGateway.setMaxEirp(context.getUnmarshaller(Float.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return loRaWANGateway;
    }

    private static LoRaWANGatewayJsonUnmarshaller instance;

    public static LoRaWANGatewayJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new LoRaWANGatewayJsonUnmarshaller();
        return instance;
    }
}
