/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.iotwireless.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * SidewalkDeviceMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class SidewalkDeviceMarshaller {

    private static final MarshallingInfo<String> AMAZONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AmazonId").build();
    private static final MarshallingInfo<String> SIDEWALKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SidewalkId").build();
    private static final MarshallingInfo<String> SIDEWALKMANUFACTURINGSN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SidewalkManufacturingSn").build();
    private static final MarshallingInfo<List> DEVICECERTIFICATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceCertificates").build();
    private static final MarshallingInfo<List> PRIVATEKEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PrivateKeys").build();
    private static final MarshallingInfo<String> DEVICEPROFILEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceProfileId").build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Status").build();

    private static final SidewalkDeviceMarshaller instance = new SidewalkDeviceMarshaller();

    public static SidewalkDeviceMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(SidewalkDevice sidewalkDevice, ProtocolMarshaller protocolMarshaller) {

        if (sidewalkDevice == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(sidewalkDevice.getAmazonId(), AMAZONID_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getSidewalkId(), SIDEWALKID_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getSidewalkManufacturingSn(), SIDEWALKMANUFACTURINGSN_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getDeviceCertificates(), DEVICECERTIFICATES_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getPrivateKeys(), PRIVATEKEYS_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getDeviceProfileId(), DEVICEPROFILEID_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getCertificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall(sidewalkDevice.getStatus(), STATUS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
