/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivs.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetStreamKeyResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /** <zonbook></zonbook><xhtml></xhtml> */
    private StreamKey streamKey;

    /**
     * <zonbook></zonbook><xhtml></xhtml>
     * 
     * @param streamKey
     */

    public void setStreamKey(StreamKey streamKey) {
        this.streamKey = streamKey;
    }

    /**
     * <zonbook></zonbook><xhtml></xhtml>
     * 
     * @return
     */

    public StreamKey getStreamKey() {
        return this.streamKey;
    }

    /**
     * <zonbook></zonbook><xhtml></xhtml>
     * 
     * @param streamKey
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetStreamKeyResult withStreamKey(StreamKey streamKey) {
        setStreamKey(streamKey);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStreamKey() != null)
            sb.append("StreamKey: ").append(getStreamKey());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetStreamKeyResult == false)
            return false;
        GetStreamKeyResult other = (GetStreamKeyResult) obj;
        if (other.getStreamKey() == null ^ this.getStreamKey() == null)
            return false;
        if (other.getStreamKey() != null && other.getStreamKey().equals(this.getStreamKey()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStreamKey() == null) ? 0 : getStreamKey().hashCode());
        return hashCode;
    }

    @Override
    public GetStreamKeyResult clone() {
        try {
            return (GetStreamKeyResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
