/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivschat;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ivschat.AmazonivschatAsync;
import com.amazonaws.services.ivschat.AmazonivschatAsyncClientBuilder;
import com.amazonaws.services.ivschat.AmazonivschatClient;
import com.amazonaws.services.ivschat.model.CreateChatTokenRequest;
import com.amazonaws.services.ivschat.model.CreateChatTokenResult;
import com.amazonaws.services.ivschat.model.CreateLoggingConfigurationRequest;
import com.amazonaws.services.ivschat.model.CreateLoggingConfigurationResult;
import com.amazonaws.services.ivschat.model.CreateRoomRequest;
import com.amazonaws.services.ivschat.model.CreateRoomResult;
import com.amazonaws.services.ivschat.model.DeleteLoggingConfigurationRequest;
import com.amazonaws.services.ivschat.model.DeleteLoggingConfigurationResult;
import com.amazonaws.services.ivschat.model.DeleteMessageRequest;
import com.amazonaws.services.ivschat.model.DeleteMessageResult;
import com.amazonaws.services.ivschat.model.DeleteRoomRequest;
import com.amazonaws.services.ivschat.model.DeleteRoomResult;
import com.amazonaws.services.ivschat.model.DisconnectUserRequest;
import com.amazonaws.services.ivschat.model.DisconnectUserResult;
import com.amazonaws.services.ivschat.model.GetLoggingConfigurationRequest;
import com.amazonaws.services.ivschat.model.GetLoggingConfigurationResult;
import com.amazonaws.services.ivschat.model.GetRoomRequest;
import com.amazonaws.services.ivschat.model.GetRoomResult;
import com.amazonaws.services.ivschat.model.ListLoggingConfigurationsRequest;
import com.amazonaws.services.ivschat.model.ListLoggingConfigurationsResult;
import com.amazonaws.services.ivschat.model.ListRoomsRequest;
import com.amazonaws.services.ivschat.model.ListRoomsResult;
import com.amazonaws.services.ivschat.model.ListTagsForResourceRequest;
import com.amazonaws.services.ivschat.model.ListTagsForResourceResult;
import com.amazonaws.services.ivschat.model.SendEventRequest;
import com.amazonaws.services.ivschat.model.SendEventResult;
import com.amazonaws.services.ivschat.model.TagResourceRequest;
import com.amazonaws.services.ivschat.model.TagResourceResult;
import com.amazonaws.services.ivschat.model.UntagResourceRequest;
import com.amazonaws.services.ivschat.model.UntagResourceResult;
import com.amazonaws.services.ivschat.model.UpdateLoggingConfigurationRequest;
import com.amazonaws.services.ivschat.model.UpdateLoggingConfigurationResult;
import com.amazonaws.services.ivschat.model.UpdateRoomRequest;
import com.amazonaws.services.ivschat.model.UpdateRoomResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonivschatAsyncClient
extends AmazonivschatClient
implements AmazonivschatAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonivschatAsyncClientBuilder asyncBuilder() {
        return AmazonivschatAsyncClientBuilder.standard();
    }

    AmazonivschatAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonivschatAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChatTokenResult> createChatTokenAsync(CreateChatTokenRequest request) {
        return this.createChatTokenAsync(request, null);
    }

    @Override
    public Future<CreateChatTokenResult> createChatTokenAsync(CreateChatTokenRequest request, final AsyncHandler<CreateChatTokenRequest, CreateChatTokenResult> asyncHandler) {
        final CreateChatTokenRequest finalRequest = (CreateChatTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChatTokenResult>(){

            @Override
            public CreateChatTokenResult call() throws Exception {
                CreateChatTokenResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeCreateChatToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLoggingConfigurationResult> createLoggingConfigurationAsync(CreateLoggingConfigurationRequest request) {
        return this.createLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateLoggingConfigurationResult> createLoggingConfigurationAsync(CreateLoggingConfigurationRequest request, final AsyncHandler<CreateLoggingConfigurationRequest, CreateLoggingConfigurationResult> asyncHandler) {
        final CreateLoggingConfigurationRequest finalRequest = (CreateLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLoggingConfigurationResult>(){

            @Override
            public CreateLoggingConfigurationResult call() throws Exception {
                CreateLoggingConfigurationResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeCreateLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRoomResult> createRoomAsync(CreateRoomRequest request) {
        return this.createRoomAsync(request, null);
    }

    @Override
    public Future<CreateRoomResult> createRoomAsync(CreateRoomRequest request, final AsyncHandler<CreateRoomRequest, CreateRoomResult> asyncHandler) {
        final CreateRoomRequest finalRequest = (CreateRoomRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRoomResult>(){

            @Override
            public CreateRoomResult call() throws Exception {
                CreateRoomResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeCreateRoom(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLoggingConfigurationResult> deleteLoggingConfigurationAsync(DeleteLoggingConfigurationRequest request) {
        return this.deleteLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteLoggingConfigurationResult> deleteLoggingConfigurationAsync(DeleteLoggingConfigurationRequest request, final AsyncHandler<DeleteLoggingConfigurationRequest, DeleteLoggingConfigurationResult> asyncHandler) {
        final DeleteLoggingConfigurationRequest finalRequest = (DeleteLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLoggingConfigurationResult>(){

            @Override
            public DeleteLoggingConfigurationResult call() throws Exception {
                DeleteLoggingConfigurationResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeDeleteLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest request) {
        return this.deleteMessageAsync(request, null);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest request, final AsyncHandler<DeleteMessageRequest, DeleteMessageResult> asyncHandler) {
        final DeleteMessageRequest finalRequest = (DeleteMessageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMessageResult>(){

            @Override
            public DeleteMessageResult call() throws Exception {
                DeleteMessageResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeDeleteMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRoomResult> deleteRoomAsync(DeleteRoomRequest request) {
        return this.deleteRoomAsync(request, null);
    }

    @Override
    public Future<DeleteRoomResult> deleteRoomAsync(DeleteRoomRequest request, final AsyncHandler<DeleteRoomRequest, DeleteRoomResult> asyncHandler) {
        final DeleteRoomRequest finalRequest = (DeleteRoomRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRoomResult>(){

            @Override
            public DeleteRoomResult call() throws Exception {
                DeleteRoomResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeDeleteRoom(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisconnectUserResult> disconnectUserAsync(DisconnectUserRequest request) {
        return this.disconnectUserAsync(request, null);
    }

    @Override
    public Future<DisconnectUserResult> disconnectUserAsync(DisconnectUserRequest request, final AsyncHandler<DisconnectUserRequest, DisconnectUserResult> asyncHandler) {
        final DisconnectUserRequest finalRequest = (DisconnectUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisconnectUserResult>(){

            @Override
            public DisconnectUserResult call() throws Exception {
                DisconnectUserResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeDisconnectUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLoggingConfigurationResult> getLoggingConfigurationAsync(GetLoggingConfigurationRequest request) {
        return this.getLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<GetLoggingConfigurationResult> getLoggingConfigurationAsync(GetLoggingConfigurationRequest request, final AsyncHandler<GetLoggingConfigurationRequest, GetLoggingConfigurationResult> asyncHandler) {
        final GetLoggingConfigurationRequest finalRequest = (GetLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLoggingConfigurationResult>(){

            @Override
            public GetLoggingConfigurationResult call() throws Exception {
                GetLoggingConfigurationResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeGetLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRoomResult> getRoomAsync(GetRoomRequest request) {
        return this.getRoomAsync(request, null);
    }

    @Override
    public Future<GetRoomResult> getRoomAsync(GetRoomRequest request, final AsyncHandler<GetRoomRequest, GetRoomResult> asyncHandler) {
        final GetRoomRequest finalRequest = (GetRoomRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRoomResult>(){

            @Override
            public GetRoomResult call() throws Exception {
                GetRoomResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeGetRoom(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLoggingConfigurationsResult> listLoggingConfigurationsAsync(ListLoggingConfigurationsRequest request) {
        return this.listLoggingConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListLoggingConfigurationsResult> listLoggingConfigurationsAsync(ListLoggingConfigurationsRequest request, final AsyncHandler<ListLoggingConfigurationsRequest, ListLoggingConfigurationsResult> asyncHandler) {
        final ListLoggingConfigurationsRequest finalRequest = (ListLoggingConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLoggingConfigurationsResult>(){

            @Override
            public ListLoggingConfigurationsResult call() throws Exception {
                ListLoggingConfigurationsResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeListLoggingConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRoomsResult> listRoomsAsync(ListRoomsRequest request) {
        return this.listRoomsAsync(request, null);
    }

    @Override
    public Future<ListRoomsResult> listRoomsAsync(ListRoomsRequest request, final AsyncHandler<ListRoomsRequest, ListRoomsResult> asyncHandler) {
        final ListRoomsRequest finalRequest = (ListRoomsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRoomsResult>(){

            @Override
            public ListRoomsResult call() throws Exception {
                ListRoomsResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeListRooms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendEventResult> sendEventAsync(SendEventRequest request) {
        return this.sendEventAsync(request, null);
    }

    @Override
    public Future<SendEventResult> sendEventAsync(SendEventRequest request, final AsyncHandler<SendEventRequest, SendEventResult> asyncHandler) {
        final SendEventRequest finalRequest = (SendEventRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendEventResult>(){

            @Override
            public SendEventResult call() throws Exception {
                SendEventResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeSendEvent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLoggingConfigurationResult> updateLoggingConfigurationAsync(UpdateLoggingConfigurationRequest request) {
        return this.updateLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateLoggingConfigurationResult> updateLoggingConfigurationAsync(UpdateLoggingConfigurationRequest request, final AsyncHandler<UpdateLoggingConfigurationRequest, UpdateLoggingConfigurationResult> asyncHandler) {
        final UpdateLoggingConfigurationRequest finalRequest = (UpdateLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLoggingConfigurationResult>(){

            @Override
            public UpdateLoggingConfigurationResult call() throws Exception {
                UpdateLoggingConfigurationResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeUpdateLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRoomResult> updateRoomAsync(UpdateRoomRequest request) {
        return this.updateRoomAsync(request, null);
    }

    @Override
    public Future<UpdateRoomResult> updateRoomAsync(UpdateRoomRequest request, final AsyncHandler<UpdateRoomRequest, UpdateRoomResult> asyncHandler) {
        final UpdateRoomRequest finalRequest = (UpdateRoomRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRoomResult>(){

            @Override
            public UpdateRoomResult call() throws Exception {
                UpdateRoomResult result = null;
                try {
                    result = AmazonivschatAsyncClient.this.executeUpdateRoom(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

