/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivschat.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivschat-2020-07-14/UpdateRoom" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateRoomResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Room ARN, from the request (if <code>identifier</code> was an ARN).
     * </p>
     */
    private String arn;
    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     */
    private String id;
    /**
     * <p>
     * Room name, from the request (if specified).
     * </p>
     */
    private String name;
    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     */
    private java.util.Date createTime;
    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     */
    private java.util.Date updateTime;
    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     * specified).
     * </p>
     */
    private Integer maximumMessageRatePerSecond;
    /**
     * <p>
     * Maximum number of characters in a single message, from the request (if specified).
     * </p>
     */
    private Integer maximumMessageLength;
    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     */
    private MessageReviewHandler messageReviewHandler;
    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * Array of logging configurations attached to the room, from the request (if specified).
     * </p>
     */
    private java.util.List<String> loggingConfigurationIdentifiers;

    /**
     * <p>
     * Room ARN, from the request (if <code>identifier</code> was an ARN).
     * </p>
     * 
     * @param arn
     *        Room ARN, from the request (if <code>identifier</code> was an ARN).
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Room ARN, from the request (if <code>identifier</code> was an ARN).
     * </p>
     * 
     * @return Room ARN, from the request (if <code>identifier</code> was an ARN).
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Room ARN, from the request (if <code>identifier</code> was an ARN).
     * </p>
     * 
     * @param arn
     *        Room ARN, from the request (if <code>identifier</code> was an ARN).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     * 
     * @param id
     *        Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
     *        identifies the room.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     * 
     * @return Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
     *         identifies the room.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the
     * room.
     * </p>
     * 
     * @param id
     *        Room ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely
     *        identifies the room.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * Room name, from the request (if specified).
     * </p>
     * 
     * @param name
     *        Room name, from the request (if specified).
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Room name, from the request (if specified).
     * </p>
     * 
     * @return Room name, from the request (if specified).
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Room name, from the request (if specified).
     * </p>
     * 
     * @param name
     *        Room name, from the request (if specified).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @param createTime
     *        Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *        string</i>.
     */

    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */

    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * <p>
     * Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @param createTime
     *        Time when the room was created. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *        string</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withCreateTime(java.util.Date createTime) {
        setCreateTime(createTime);
        return this;
    }

    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @param updateTime
     *        Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *        string</i>.
     */

    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */

    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * <p>
     * Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @param updateTime
     *        Time of the room’s last update. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *        string</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withUpdateTime(java.util.Date updateTime) {
        setUpdateTime(updateTime);
        return this;
    }

    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     * specified).
     * </p>
     * 
     * @param maximumMessageRatePerSecond
     *        Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     *        specified).
     */

    public void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
        this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
    }

    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     * specified).
     * </p>
     * 
     * @return Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     *         specified).
     */

    public Integer getMaximumMessageRatePerSecond() {
        return this.maximumMessageRatePerSecond;
    }

    /**
     * <p>
     * Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     * specified).
     * </p>
     * 
     * @param maximumMessageRatePerSecond
     *        Maximum number of messages per second that can be sent to the room (by all clients), from the request (if
     *        specified).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
        setMaximumMessageRatePerSecond(maximumMessageRatePerSecond);
        return this;
    }

    /**
     * <p>
     * Maximum number of characters in a single message, from the request (if specified).
     * </p>
     * 
     * @param maximumMessageLength
     *        Maximum number of characters in a single message, from the request (if specified).
     */

    public void setMaximumMessageLength(Integer maximumMessageLength) {
        this.maximumMessageLength = maximumMessageLength;
    }

    /**
     * <p>
     * Maximum number of characters in a single message, from the request (if specified).
     * </p>
     * 
     * @return Maximum number of characters in a single message, from the request (if specified).
     */

    public Integer getMaximumMessageLength() {
        return this.maximumMessageLength;
    }

    /**
     * <p>
     * Maximum number of characters in a single message, from the request (if specified).
     * </p>
     * 
     * @param maximumMessageLength
     *        Maximum number of characters in a single message, from the request (if specified).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withMaximumMessageLength(Integer maximumMessageLength) {
        setMaximumMessageLength(maximumMessageLength);
        return this;
    }

    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     * 
     * @param messageReviewHandler
     *        Configuration information for optional review of messages.
     */

    public void setMessageReviewHandler(MessageReviewHandler messageReviewHandler) {
        this.messageReviewHandler = messageReviewHandler;
    }

    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     * 
     * @return Configuration information for optional review of messages.
     */

    public MessageReviewHandler getMessageReviewHandler() {
        return this.messageReviewHandler;
    }

    /**
     * <p>
     * Configuration information for optional review of messages.
     * </p>
     * 
     * @param messageReviewHandler
     *        Configuration information for optional review of messages.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withMessageReviewHandler(MessageReviewHandler messageReviewHandler) {
        setMessageReviewHandler(messageReviewHandler);
        return this;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     * 
     * @param tags
     *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     * 
     * @param tags
     *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see UpdateRoomResult#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * Array of logging configurations attached to the room, from the request (if specified).
     * </p>
     * 
     * @return Array of logging configurations attached to the room, from the request (if specified).
     */

    public java.util.List<String> getLoggingConfigurationIdentifiers() {
        return loggingConfigurationIdentifiers;
    }

    /**
     * <p>
     * Array of logging configurations attached to the room, from the request (if specified).
     * </p>
     * 
     * @param loggingConfigurationIdentifiers
     *        Array of logging configurations attached to the room, from the request (if specified).
     */

    public void setLoggingConfigurationIdentifiers(java.util.Collection<String> loggingConfigurationIdentifiers) {
        if (loggingConfigurationIdentifiers == null) {
            this.loggingConfigurationIdentifiers = null;
            return;
        }

        this.loggingConfigurationIdentifiers = new java.util.ArrayList<String>(loggingConfigurationIdentifiers);
    }

    /**
     * <p>
     * Array of logging configurations attached to the room, from the request (if specified).
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLoggingConfigurationIdentifiers(java.util.Collection)} or
     * {@link #withLoggingConfigurationIdentifiers(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param loggingConfigurationIdentifiers
     *        Array of logging configurations attached to the room, from the request (if specified).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withLoggingConfigurationIdentifiers(String... loggingConfigurationIdentifiers) {
        if (this.loggingConfigurationIdentifiers == null) {
            setLoggingConfigurationIdentifiers(new java.util.ArrayList<String>(loggingConfigurationIdentifiers.length));
        }
        for (String ele : loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Array of logging configurations attached to the room, from the request (if specified).
     * </p>
     * 
     * @param loggingConfigurationIdentifiers
     *        Array of logging configurations attached to the room, from the request (if specified).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateRoomResult withLoggingConfigurationIdentifiers(java.util.Collection<String> loggingConfigurationIdentifiers) {
        setLoggingConfigurationIdentifiers(loggingConfigurationIdentifiers);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getCreateTime() != null)
            sb.append("CreateTime: ").append(getCreateTime()).append(",");
        if (getUpdateTime() != null)
            sb.append("UpdateTime: ").append(getUpdateTime()).append(",");
        if (getMaximumMessageRatePerSecond() != null)
            sb.append("MaximumMessageRatePerSecond: ").append(getMaximumMessageRatePerSecond()).append(",");
        if (getMaximumMessageLength() != null)
            sb.append("MaximumMessageLength: ").append(getMaximumMessageLength()).append(",");
        if (getMessageReviewHandler() != null)
            sb.append("MessageReviewHandler: ").append(getMessageReviewHandler()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getLoggingConfigurationIdentifiers() != null)
            sb.append("LoggingConfigurationIdentifiers: ").append(getLoggingConfigurationIdentifiers());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateRoomResult == false)
            return false;
        UpdateRoomResult other = (UpdateRoomResult) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getCreateTime() == null ^ this.getCreateTime() == null)
            return false;
        if (other.getCreateTime() != null && other.getCreateTime().equals(this.getCreateTime()) == false)
            return false;
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null)
            return false;
        if (other.getUpdateTime() != null && other.getUpdateTime().equals(this.getUpdateTime()) == false)
            return false;
        if (other.getMaximumMessageRatePerSecond() == null ^ this.getMaximumMessageRatePerSecond() == null)
            return false;
        if (other.getMaximumMessageRatePerSecond() != null && other.getMaximumMessageRatePerSecond().equals(this.getMaximumMessageRatePerSecond()) == false)
            return false;
        if (other.getMaximumMessageLength() == null ^ this.getMaximumMessageLength() == null)
            return false;
        if (other.getMaximumMessageLength() != null && other.getMaximumMessageLength().equals(this.getMaximumMessageLength()) == false)
            return false;
        if (other.getMessageReviewHandler() == null ^ this.getMessageReviewHandler() == null)
            return false;
        if (other.getMessageReviewHandler() != null && other.getMessageReviewHandler().equals(this.getMessageReviewHandler()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getLoggingConfigurationIdentifiers() == null ^ this.getLoggingConfigurationIdentifiers() == null)
            return false;
        if (other.getLoggingConfigurationIdentifiers() != null
                && other.getLoggingConfigurationIdentifiers().equals(this.getLoggingConfigurationIdentifiers()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getCreateTime() == null) ? 0 : getCreateTime().hashCode());
        hashCode = prime * hashCode + ((getUpdateTime() == null) ? 0 : getUpdateTime().hashCode());
        hashCode = prime * hashCode + ((getMaximumMessageRatePerSecond() == null) ? 0 : getMaximumMessageRatePerSecond().hashCode());
        hashCode = prime * hashCode + ((getMaximumMessageLength() == null) ? 0 : getMaximumMessageLength().hashCode());
        hashCode = prime * hashCode + ((getMessageReviewHandler() == null) ? 0 : getMessageReviewHandler().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getLoggingConfigurationIdentifiers() == null) ? 0 : getLoggingConfigurationIdentifiers().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRoomResult clone() {
        try {
            return (UpdateRoomResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
