/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ivsrealtime.AmazonIVSRealTimeAsync;
import com.amazonaws.services.ivsrealtime.AmazonIVSRealTimeAsyncClientBuilder;
import com.amazonaws.services.ivsrealtime.AmazonIVSRealTimeClient;
import com.amazonaws.services.ivsrealtime.model.CreateParticipantTokenRequest;
import com.amazonaws.services.ivsrealtime.model.CreateParticipantTokenResult;
import com.amazonaws.services.ivsrealtime.model.CreateStageRequest;
import com.amazonaws.services.ivsrealtime.model.CreateStageResult;
import com.amazonaws.services.ivsrealtime.model.DeleteStageRequest;
import com.amazonaws.services.ivsrealtime.model.DeleteStageResult;
import com.amazonaws.services.ivsrealtime.model.DisconnectParticipantRequest;
import com.amazonaws.services.ivsrealtime.model.DisconnectParticipantResult;
import com.amazonaws.services.ivsrealtime.model.GetStageRequest;
import com.amazonaws.services.ivsrealtime.model.GetStageResult;
import com.amazonaws.services.ivsrealtime.model.ListStagesRequest;
import com.amazonaws.services.ivsrealtime.model.ListStagesResult;
import com.amazonaws.services.ivsrealtime.model.ListTagsForResourceRequest;
import com.amazonaws.services.ivsrealtime.model.ListTagsForResourceResult;
import com.amazonaws.services.ivsrealtime.model.TagResourceRequest;
import com.amazonaws.services.ivsrealtime.model.TagResourceResult;
import com.amazonaws.services.ivsrealtime.model.UntagResourceRequest;
import com.amazonaws.services.ivsrealtime.model.UntagResourceResult;
import com.amazonaws.services.ivsrealtime.model.UpdateStageRequest;
import com.amazonaws.services.ivsrealtime.model.UpdateStageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonIVSRealTimeAsyncClient
extends AmazonIVSRealTimeClient
implements AmazonIVSRealTimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonIVSRealTimeAsyncClientBuilder asyncBuilder() {
        return AmazonIVSRealTimeAsyncClientBuilder.standard();
    }

    AmazonIVSRealTimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonIVSRealTimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateParticipantTokenResult> createParticipantTokenAsync(CreateParticipantTokenRequest request) {
        return this.createParticipantTokenAsync(request, null);
    }

    @Override
    public Future<CreateParticipantTokenResult> createParticipantTokenAsync(CreateParticipantTokenRequest request, final AsyncHandler<CreateParticipantTokenRequest, CreateParticipantTokenResult> asyncHandler) {
        final CreateParticipantTokenRequest finalRequest = (CreateParticipantTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateParticipantTokenResult>(){

            @Override
            public CreateParticipantTokenResult call() throws Exception {
                CreateParticipantTokenResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeCreateParticipantToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStageResult> createStageAsync(CreateStageRequest request) {
        return this.createStageAsync(request, null);
    }

    @Override
    public Future<CreateStageResult> createStageAsync(CreateStageRequest request, final AsyncHandler<CreateStageRequest, CreateStageResult> asyncHandler) {
        final CreateStageRequest finalRequest = (CreateStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStageResult>(){

            @Override
            public CreateStageResult call() throws Exception {
                CreateStageResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeCreateStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request) {
        return this.deleteStageAsync(request, null);
    }

    @Override
    public Future<DeleteStageResult> deleteStageAsync(DeleteStageRequest request, final AsyncHandler<DeleteStageRequest, DeleteStageResult> asyncHandler) {
        final DeleteStageRequest finalRequest = (DeleteStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStageResult>(){

            @Override
            public DeleteStageResult call() throws Exception {
                DeleteStageResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeDeleteStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisconnectParticipantResult> disconnectParticipantAsync(DisconnectParticipantRequest request) {
        return this.disconnectParticipantAsync(request, null);
    }

    @Override
    public Future<DisconnectParticipantResult> disconnectParticipantAsync(DisconnectParticipantRequest request, final AsyncHandler<DisconnectParticipantRequest, DisconnectParticipantResult> asyncHandler) {
        final DisconnectParticipantRequest finalRequest = (DisconnectParticipantRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisconnectParticipantResult>(){

            @Override
            public DisconnectParticipantResult call() throws Exception {
                DisconnectParticipantResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeDisconnectParticipant(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStageResult> getStageAsync(GetStageRequest request) {
        return this.getStageAsync(request, null);
    }

    @Override
    public Future<GetStageResult> getStageAsync(GetStageRequest request, final AsyncHandler<GetStageRequest, GetStageResult> asyncHandler) {
        final GetStageRequest finalRequest = (GetStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStageResult>(){

            @Override
            public GetStageResult call() throws Exception {
                GetStageResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeGetStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStagesResult> listStagesAsync(ListStagesRequest request) {
        return this.listStagesAsync(request, null);
    }

    @Override
    public Future<ListStagesResult> listStagesAsync(ListStagesRequest request, final AsyncHandler<ListStagesRequest, ListStagesResult> asyncHandler) {
        final ListStagesRequest finalRequest = (ListStagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStagesResult>(){

            @Override
            public ListStagesResult call() throws Exception {
                ListStagesResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeListStages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request) {
        return this.updateStageAsync(request, null);
    }

    @Override
    public Future<UpdateStageResult> updateStageAsync(UpdateStageRequest request, final AsyncHandler<UpdateStageRequest, UpdateStageResult> asyncHandler) {
        final UpdateStageRequest finalRequest = (UpdateStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStageResult>(){

            @Override
            public UpdateStageResult call() throws Exception {
                UpdateStageResult result = null;
                try {
                    result = AmazonIVSRealTimeAsyncClient.this.executeUpdateStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

