/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivsrealtime.model.CompositionState;
import com.amazonaws.services.ivsrealtime.model.DestinationSummary;
import com.amazonaws.services.ivsrealtime.model.transform.CompositionSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositionSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<DestinationSummary> destinations;
    private Date endTime;
    private String stageArn;
    private Date startTime;
    private String state;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public CompositionSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<DestinationSummary> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<DestinationSummary> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<DestinationSummary>(destinations);
    }

    public CompositionSummary withDestinations(DestinationSummary ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<DestinationSummary>(destinations.length));
        }
        for (DestinationSummary ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public CompositionSummary withDestinations(Collection<DestinationSummary> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CompositionSummary withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setStageArn(String stageArn) {
        this.stageArn = stageArn;
    }

    public String getStageArn() {
        return this.stageArn;
    }

    public CompositionSummary withStageArn(String stageArn) {
        this.setStageArn(stageArn);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public CompositionSummary withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public CompositionSummary withState(String state) {
        this.setState(state);
        return this;
    }

    public CompositionSummary withState(CompositionState state) {
        this.state = state.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CompositionSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CompositionSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CompositionSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getStageArn() != null) {
            sb.append("StageArn: ").append(this.getStageArn()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositionSummary)) {
            return false;
        }
        CompositionSummary other = (CompositionSummary)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getStageArn() == null ^ this.getStageArn() == null) {
            return false;
        }
        if (other.getStageArn() != null && !other.getStageArn().equals(this.getStageArn())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getStageArn() == null ? 0 : this.getStageArn().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CompositionSummary clone() {
        try {
            return (CompositionSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompositionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

