/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivsrealtime.model.ParticipantTokenCapability;
import com.amazonaws.services.ivsrealtime.model.transform.ParticipantTokenMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParticipantToken
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> attributes;
    private List<String> capabilities;
    private Integer duration;
    private Date expirationTime;
    private String participantId;
    private String token;
    private String userId;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ParticipantToken withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public ParticipantToken addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public ParticipantToken clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public ParticipantToken withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public ParticipantToken withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public ParticipantToken withCapabilities(ParticipantTokenCapability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (ParticipantTokenCapability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public ParticipantToken withDuration(Integer duration) {
        this.setDuration(duration);
        return this;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public ParticipantToken withExpirationTime(Date expirationTime) {
        this.setExpirationTime(expirationTime);
        return this;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public ParticipantToken withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public ParticipantToken withToken(String token) {
        this.setToken(token);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ParticipantToken withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getExpirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.getExpirationTime()).append(",");
        }
        if (this.getParticipantId() != null) {
            sb.append("ParticipantId: ").append(this.getParticipantId()).append(",");
        }
        if (this.getToken() != null) {
            sb.append("Token: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantToken)) {
            return false;
        }
        ParticipantToken other = (ParticipantToken)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getParticipantId() == null ^ this.getParticipantId() == null) {
            return false;
        }
        if (other.getParticipantId() != null && !other.getParticipantId().equals(this.getParticipantId())) {
            return false;
        }
        if (other.getToken() == null ^ this.getToken() == null) {
            return false;
        }
        if (other.getToken() != null && !other.getToken().equals(this.getToken())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        return other.getUserId() == null || other.getUserId().equals(this.getUserId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantId() == null ? 0 : this.getParticipantId().hashCode());
        hashCode = 31 * hashCode + (this.getToken() == null ? 0 : this.getToken().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return hashCode;
    }

    public ParticipantToken clone() {
        try {
            return (ParticipantToken)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParticipantTokenMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

