/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivsrealtime.model.ParticipantRecordingMediaType;
import com.amazonaws.services.ivsrealtime.model.transform.AutoParticipantRecordingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoParticipantRecordingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String storageConfigurationArn;
    private List<String> mediaTypes;

    public void setStorageConfigurationArn(String storageConfigurationArn) {
        this.storageConfigurationArn = storageConfigurationArn;
    }

    public String getStorageConfigurationArn() {
        return this.storageConfigurationArn;
    }

    public AutoParticipantRecordingConfiguration withStorageConfigurationArn(String storageConfigurationArn) {
        this.setStorageConfigurationArn(storageConfigurationArn);
        return this;
    }

    public List<String> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(Collection<String> mediaTypes) {
        if (mediaTypes == null) {
            this.mediaTypes = null;
            return;
        }
        this.mediaTypes = new ArrayList<String>(mediaTypes);
    }

    public AutoParticipantRecordingConfiguration withMediaTypes(String ... mediaTypes) {
        if (this.mediaTypes == null) {
            this.setMediaTypes(new ArrayList<String>(mediaTypes.length));
        }
        for (String ele : mediaTypes) {
            this.mediaTypes.add(ele);
        }
        return this;
    }

    public AutoParticipantRecordingConfiguration withMediaTypes(Collection<String> mediaTypes) {
        this.setMediaTypes(mediaTypes);
        return this;
    }

    public AutoParticipantRecordingConfiguration withMediaTypes(ParticipantRecordingMediaType ... mediaTypes) {
        ArrayList<String> mediaTypesCopy = new ArrayList<String>(mediaTypes.length);
        for (ParticipantRecordingMediaType value : mediaTypes) {
            mediaTypesCopy.add(value.toString());
        }
        if (this.getMediaTypes() == null) {
            this.setMediaTypes(mediaTypesCopy);
        } else {
            this.getMediaTypes().addAll(mediaTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageConfigurationArn() != null) {
            sb.append("StorageConfigurationArn: ").append(this.getStorageConfigurationArn()).append(",");
        }
        if (this.getMediaTypes() != null) {
            sb.append("MediaTypes: ").append(this.getMediaTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParticipantRecordingConfiguration)) {
            return false;
        }
        AutoParticipantRecordingConfiguration other = (AutoParticipantRecordingConfiguration)obj;
        if (other.getStorageConfigurationArn() == null ^ this.getStorageConfigurationArn() == null) {
            return false;
        }
        if (other.getStorageConfigurationArn() != null && !other.getStorageConfigurationArn().equals(this.getStorageConfigurationArn())) {
            return false;
        }
        if (other.getMediaTypes() == null ^ this.getMediaTypes() == null) {
            return false;
        }
        return other.getMediaTypes() == null || other.getMediaTypes().equals(this.getMediaTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageConfigurationArn() == null ? 0 : this.getStorageConfigurationArn().hashCode());
        hashCode = 31 * hashCode + (this.getMediaTypes() == null ? 0 : this.getMediaTypes().hashCode());
        return hashCode;
    }

    public AutoParticipantRecordingConfiguration clone() {
        try {
            return (AutoParticipantRecordingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoParticipantRecordingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

