/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kafka.AWSKafkaAsync;
import com.amazonaws.services.kafka.AWSKafkaAsyncClientBuilder;
import com.amazonaws.services.kafka.AWSKafkaClient;
import com.amazonaws.services.kafka.model.BatchAssociateScramSecretRequest;
import com.amazonaws.services.kafka.model.BatchAssociateScramSecretResult;
import com.amazonaws.services.kafka.model.BatchDisassociateScramSecretRequest;
import com.amazonaws.services.kafka.model.BatchDisassociateScramSecretResult;
import com.amazonaws.services.kafka.model.CreateClusterRequest;
import com.amazonaws.services.kafka.model.CreateClusterResult;
import com.amazonaws.services.kafka.model.CreateConfigurationRequest;
import com.amazonaws.services.kafka.model.CreateConfigurationResult;
import com.amazonaws.services.kafka.model.DeleteClusterRequest;
import com.amazonaws.services.kafka.model.DeleteClusterResult;
import com.amazonaws.services.kafka.model.DeleteConfigurationRequest;
import com.amazonaws.services.kafka.model.DeleteConfigurationResult;
import com.amazonaws.services.kafka.model.DescribeClusterOperationRequest;
import com.amazonaws.services.kafka.model.DescribeClusterOperationResult;
import com.amazonaws.services.kafka.model.DescribeClusterRequest;
import com.amazonaws.services.kafka.model.DescribeClusterResult;
import com.amazonaws.services.kafka.model.DescribeConfigurationRequest;
import com.amazonaws.services.kafka.model.DescribeConfigurationResult;
import com.amazonaws.services.kafka.model.DescribeConfigurationRevisionRequest;
import com.amazonaws.services.kafka.model.DescribeConfigurationRevisionResult;
import com.amazonaws.services.kafka.model.GetBootstrapBrokersRequest;
import com.amazonaws.services.kafka.model.GetBootstrapBrokersResult;
import com.amazonaws.services.kafka.model.GetCompatibleKafkaVersionsRequest;
import com.amazonaws.services.kafka.model.GetCompatibleKafkaVersionsResult;
import com.amazonaws.services.kafka.model.ListClusterOperationsRequest;
import com.amazonaws.services.kafka.model.ListClusterOperationsResult;
import com.amazonaws.services.kafka.model.ListClustersRequest;
import com.amazonaws.services.kafka.model.ListClustersResult;
import com.amazonaws.services.kafka.model.ListConfigurationRevisionsRequest;
import com.amazonaws.services.kafka.model.ListConfigurationRevisionsResult;
import com.amazonaws.services.kafka.model.ListConfigurationsRequest;
import com.amazonaws.services.kafka.model.ListConfigurationsResult;
import com.amazonaws.services.kafka.model.ListKafkaVersionsRequest;
import com.amazonaws.services.kafka.model.ListKafkaVersionsResult;
import com.amazonaws.services.kafka.model.ListNodesRequest;
import com.amazonaws.services.kafka.model.ListNodesResult;
import com.amazonaws.services.kafka.model.ListScramSecretsRequest;
import com.amazonaws.services.kafka.model.ListScramSecretsResult;
import com.amazonaws.services.kafka.model.ListTagsForResourceRequest;
import com.amazonaws.services.kafka.model.ListTagsForResourceResult;
import com.amazonaws.services.kafka.model.RebootBrokerRequest;
import com.amazonaws.services.kafka.model.RebootBrokerResult;
import com.amazonaws.services.kafka.model.TagResourceRequest;
import com.amazonaws.services.kafka.model.TagResourceResult;
import com.amazonaws.services.kafka.model.UntagResourceRequest;
import com.amazonaws.services.kafka.model.UntagResourceResult;
import com.amazonaws.services.kafka.model.UpdateBrokerCountRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerCountResult;
import com.amazonaws.services.kafka.model.UpdateBrokerStorageRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerStorageResult;
import com.amazonaws.services.kafka.model.UpdateBrokerTypeRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerTypeResult;
import com.amazonaws.services.kafka.model.UpdateClusterConfigurationRequest;
import com.amazonaws.services.kafka.model.UpdateClusterConfigurationResult;
import com.amazonaws.services.kafka.model.UpdateClusterKafkaVersionRequest;
import com.amazonaws.services.kafka.model.UpdateClusterKafkaVersionResult;
import com.amazonaws.services.kafka.model.UpdateConfigurationRequest;
import com.amazonaws.services.kafka.model.UpdateConfigurationResult;
import com.amazonaws.services.kafka.model.UpdateMonitoringRequest;
import com.amazonaws.services.kafka.model.UpdateMonitoringResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSKafkaAsyncClient
extends AWSKafkaClient
implements AWSKafkaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSKafkaAsyncClientBuilder asyncBuilder() {
        return AWSKafkaAsyncClientBuilder.standard();
    }

    AWSKafkaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSKafkaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchAssociateScramSecretResult> batchAssociateScramSecretAsync(BatchAssociateScramSecretRequest request) {
        return this.batchAssociateScramSecretAsync(request, null);
    }

    @Override
    public Future<BatchAssociateScramSecretResult> batchAssociateScramSecretAsync(BatchAssociateScramSecretRequest request, final AsyncHandler<BatchAssociateScramSecretRequest, BatchAssociateScramSecretResult> asyncHandler) {
        final BatchAssociateScramSecretRequest finalRequest = (BatchAssociateScramSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchAssociateScramSecretResult>(){

            @Override
            public BatchAssociateScramSecretResult call() throws Exception {
                BatchAssociateScramSecretResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeBatchAssociateScramSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDisassociateScramSecretResult> batchDisassociateScramSecretAsync(BatchDisassociateScramSecretRequest request) {
        return this.batchDisassociateScramSecretAsync(request, null);
    }

    @Override
    public Future<BatchDisassociateScramSecretResult> batchDisassociateScramSecretAsync(BatchDisassociateScramSecretRequest request, final AsyncHandler<BatchDisassociateScramSecretRequest, BatchDisassociateScramSecretResult> asyncHandler) {
        final BatchDisassociateScramSecretRequest finalRequest = (BatchDisassociateScramSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDisassociateScramSecretResult>(){

            @Override
            public BatchDisassociateScramSecretResult call() throws Exception {
                BatchDisassociateScramSecretResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeBatchDisassociateScramSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request) {
        return this.createConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request, final AsyncHandler<CreateConfigurationRequest, CreateConfigurationResult> asyncHandler) {
        final CreateConfigurationRequest finalRequest = (CreateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConfigurationResult>(){

            @Override
            public CreateConfigurationResult call() throws Exception {
                CreateConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConfigurationResult> deleteConfigurationAsync(DeleteConfigurationRequest request) {
        return this.deleteConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteConfigurationResult> deleteConfigurationAsync(DeleteConfigurationRequest request, final AsyncHandler<DeleteConfigurationRequest, DeleteConfigurationResult> asyncHandler) {
        final DeleteConfigurationRequest finalRequest = (DeleteConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConfigurationResult>(){

            @Override
            public DeleteConfigurationResult call() throws Exception {
                DeleteConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        final DescribeClusterRequest finalRequest = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterOperationResult> describeClusterOperationAsync(DescribeClusterOperationRequest request) {
        return this.describeClusterOperationAsync(request, null);
    }

    @Override
    public Future<DescribeClusterOperationResult> describeClusterOperationAsync(DescribeClusterOperationRequest request, final AsyncHandler<DescribeClusterOperationRequest, DescribeClusterOperationResult> asyncHandler) {
        final DescribeClusterOperationRequest finalRequest = (DescribeClusterOperationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterOperationResult>(){

            @Override
            public DescribeClusterOperationResult call() throws Exception {
                DescribeClusterOperationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeClusterOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request) {
        return this.describeConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request, final AsyncHandler<DescribeConfigurationRequest, DescribeConfigurationResult> asyncHandler) {
        final DescribeConfigurationRequest finalRequest = (DescribeConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationResult>(){

            @Override
            public DescribeConfigurationResult call() throws Exception {
                DescribeConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request) {
        return this.describeConfigurationRevisionAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request, final AsyncHandler<DescribeConfigurationRevisionRequest, DescribeConfigurationRevisionResult> asyncHandler) {
        final DescribeConfigurationRevisionRequest finalRequest = (DescribeConfigurationRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationRevisionResult>(){

            @Override
            public DescribeConfigurationRevisionResult call() throws Exception {
                DescribeConfigurationRevisionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeConfigurationRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBootstrapBrokersResult> getBootstrapBrokersAsync(GetBootstrapBrokersRequest request) {
        return this.getBootstrapBrokersAsync(request, null);
    }

    @Override
    public Future<GetBootstrapBrokersResult> getBootstrapBrokersAsync(GetBootstrapBrokersRequest request, final AsyncHandler<GetBootstrapBrokersRequest, GetBootstrapBrokersResult> asyncHandler) {
        final GetBootstrapBrokersRequest finalRequest = (GetBootstrapBrokersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBootstrapBrokersResult>(){

            @Override
            public GetBootstrapBrokersResult call() throws Exception {
                GetBootstrapBrokersResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeGetBootstrapBrokers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCompatibleKafkaVersionsResult> getCompatibleKafkaVersionsAsync(GetCompatibleKafkaVersionsRequest request) {
        return this.getCompatibleKafkaVersionsAsync(request, null);
    }

    @Override
    public Future<GetCompatibleKafkaVersionsResult> getCompatibleKafkaVersionsAsync(GetCompatibleKafkaVersionsRequest request, final AsyncHandler<GetCompatibleKafkaVersionsRequest, GetCompatibleKafkaVersionsResult> asyncHandler) {
        final GetCompatibleKafkaVersionsRequest finalRequest = (GetCompatibleKafkaVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCompatibleKafkaVersionsResult>(){

            @Override
            public GetCompatibleKafkaVersionsResult call() throws Exception {
                GetCompatibleKafkaVersionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeGetCompatibleKafkaVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClusterOperationsResult> listClusterOperationsAsync(ListClusterOperationsRequest request) {
        return this.listClusterOperationsAsync(request, null);
    }

    @Override
    public Future<ListClusterOperationsResult> listClusterOperationsAsync(ListClusterOperationsRequest request, final AsyncHandler<ListClusterOperationsRequest, ListClusterOperationsResult> asyncHandler) {
        final ListClusterOperationsRequest finalRequest = (ListClusterOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClusterOperationsResult>(){

            @Override
            public ListClusterOperationsResult call() throws Exception {
                ListClusterOperationsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClusterOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request) {
        return this.listConfigurationRevisionsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request, final AsyncHandler<ListConfigurationRevisionsRequest, ListConfigurationRevisionsResult> asyncHandler) {
        final ListConfigurationRevisionsRequest finalRequest = (ListConfigurationRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationRevisionsResult>(){

            @Override
            public ListConfigurationRevisionsResult call() throws Exception {
                ListConfigurationRevisionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListConfigurationRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        final ListConfigurationsRequest finalRequest = (ListConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKafkaVersionsResult> listKafkaVersionsAsync(ListKafkaVersionsRequest request) {
        return this.listKafkaVersionsAsync(request, null);
    }

    @Override
    public Future<ListKafkaVersionsResult> listKafkaVersionsAsync(ListKafkaVersionsRequest request, final AsyncHandler<ListKafkaVersionsRequest, ListKafkaVersionsResult> asyncHandler) {
        final ListKafkaVersionsRequest finalRequest = (ListKafkaVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKafkaVersionsResult>(){

            @Override
            public ListKafkaVersionsResult call() throws Exception {
                ListKafkaVersionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListKafkaVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request) {
        return this.listNodesAsync(request, null);
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request, final AsyncHandler<ListNodesRequest, ListNodesResult> asyncHandler) {
        final ListNodesRequest finalRequest = (ListNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodesResult>(){

            @Override
            public ListNodesResult call() throws Exception {
                ListNodesResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScramSecretsResult> listScramSecretsAsync(ListScramSecretsRequest request) {
        return this.listScramSecretsAsync(request, null);
    }

    @Override
    public Future<ListScramSecretsResult> listScramSecretsAsync(ListScramSecretsRequest request, final AsyncHandler<ListScramSecretsRequest, ListScramSecretsResult> asyncHandler) {
        final ListScramSecretsRequest finalRequest = (ListScramSecretsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScramSecretsResult>(){

            @Override
            public ListScramSecretsResult call() throws Exception {
                ListScramSecretsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListScramSecrets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request) {
        return this.rebootBrokerAsync(request, null);
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request, final AsyncHandler<RebootBrokerRequest, RebootBrokerResult> asyncHandler) {
        final RebootBrokerRequest finalRequest = (RebootBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootBrokerResult>(){

            @Override
            public RebootBrokerResult call() throws Exception {
                RebootBrokerResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeRebootBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerCountResult> updateBrokerCountAsync(UpdateBrokerCountRequest request) {
        return this.updateBrokerCountAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerCountResult> updateBrokerCountAsync(UpdateBrokerCountRequest request, final AsyncHandler<UpdateBrokerCountRequest, UpdateBrokerCountResult> asyncHandler) {
        final UpdateBrokerCountRequest finalRequest = (UpdateBrokerCountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerCountResult>(){

            @Override
            public UpdateBrokerCountResult call() throws Exception {
                UpdateBrokerCountResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerCount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerStorageResult> updateBrokerStorageAsync(UpdateBrokerStorageRequest request) {
        return this.updateBrokerStorageAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerStorageResult> updateBrokerStorageAsync(UpdateBrokerStorageRequest request, final AsyncHandler<UpdateBrokerStorageRequest, UpdateBrokerStorageResult> asyncHandler) {
        final UpdateBrokerStorageRequest finalRequest = (UpdateBrokerStorageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerStorageResult>(){

            @Override
            public UpdateBrokerStorageResult call() throws Exception {
                UpdateBrokerStorageResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerStorage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerTypeResult> updateBrokerTypeAsync(UpdateBrokerTypeRequest request) {
        return this.updateBrokerTypeAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerTypeResult> updateBrokerTypeAsync(UpdateBrokerTypeRequest request, final AsyncHandler<UpdateBrokerTypeRequest, UpdateBrokerTypeResult> asyncHandler) {
        final UpdateBrokerTypeRequest finalRequest = (UpdateBrokerTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerTypeResult>(){

            @Override
            public UpdateBrokerTypeResult call() throws Exception {
                UpdateBrokerTypeResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterConfigurationResult> updateClusterConfigurationAsync(UpdateClusterConfigurationRequest request) {
        return this.updateClusterConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateClusterConfigurationResult> updateClusterConfigurationAsync(UpdateClusterConfigurationRequest request, final AsyncHandler<UpdateClusterConfigurationRequest, UpdateClusterConfigurationResult> asyncHandler) {
        final UpdateClusterConfigurationRequest finalRequest = (UpdateClusterConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterConfigurationResult>(){

            @Override
            public UpdateClusterConfigurationResult call() throws Exception {
                UpdateClusterConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateClusterConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterKafkaVersionResult> updateClusterKafkaVersionAsync(UpdateClusterKafkaVersionRequest request) {
        return this.updateClusterKafkaVersionAsync(request, null);
    }

    @Override
    public Future<UpdateClusterKafkaVersionResult> updateClusterKafkaVersionAsync(UpdateClusterKafkaVersionRequest request, final AsyncHandler<UpdateClusterKafkaVersionRequest, UpdateClusterKafkaVersionResult> asyncHandler) {
        final UpdateClusterKafkaVersionRequest finalRequest = (UpdateClusterKafkaVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterKafkaVersionResult>(){

            @Override
            public UpdateClusterKafkaVersionResult call() throws Exception {
                UpdateClusterKafkaVersionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateClusterKafkaVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.updateConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request, final AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResult> asyncHandler) {
        final UpdateConfigurationRequest finalRequest = (UpdateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConfigurationResult>(){

            @Override
            public UpdateConfigurationResult call() throws Exception {
                UpdateConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMonitoringResult> updateMonitoringAsync(UpdateMonitoringRequest request) {
        return this.updateMonitoringAsync(request, null);
    }

    @Override
    public Future<UpdateMonitoringResult> updateMonitoringAsync(UpdateMonitoringRequest request, final AsyncHandler<UpdateMonitoringRequest, UpdateMonitoringResult> asyncHandler) {
        final UpdateMonitoringRequest finalRequest = (UpdateMonitoringRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMonitoringResult>(){

            @Override
            public UpdateMonitoringResult call() throws Exception {
                UpdateMonitoringResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateMonitoring(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

