/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ClusterState;
import com.amazonaws.services.kafka.model.ClusterType;
import com.amazonaws.services.kafka.model.Provisioned;
import com.amazonaws.services.kafka.model.Serverless;
import com.amazonaws.services.kafka.model.StateInfo;
import com.amazonaws.services.kafka.model.transform.ClusterMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String activeOperationArn;
    private String clusterType;
    private String clusterArn;
    private String clusterName;
    private Date creationTime;
    private String currentVersion;
    private String state;
    private StateInfo stateInfo;
    private Map<String, String> tags;
    private Provisioned provisioned;
    private Serverless serverless;

    public void setActiveOperationArn(String activeOperationArn) {
        this.activeOperationArn = activeOperationArn;
    }

    public String getActiveOperationArn() {
        return this.activeOperationArn;
    }

    public Cluster withActiveOperationArn(String activeOperationArn) {
        this.setActiveOperationArn(activeOperationArn);
        return this;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public Cluster withClusterType(String clusterType) {
        this.setClusterType(clusterType);
        return this;
    }

    public Cluster withClusterType(ClusterType clusterType) {
        this.clusterType = clusterType.toString();
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Cluster withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Cluster withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Cluster withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public Cluster withCurrentVersion(String currentVersion) {
        this.setCurrentVersion(currentVersion);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Cluster withState(String state) {
        this.setState(state);
        return this;
    }

    public Cluster withState(ClusterState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateInfo(StateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public StateInfo getStateInfo() {
        return this.stateInfo;
    }

    public Cluster withStateInfo(StateInfo stateInfo) {
        this.setStateInfo(stateInfo);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Cluster withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Cluster addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Cluster clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setProvisioned(Provisioned provisioned) {
        this.provisioned = provisioned;
    }

    public Provisioned getProvisioned() {
        return this.provisioned;
    }

    public Cluster withProvisioned(Provisioned provisioned) {
        this.setProvisioned(provisioned);
        return this;
    }

    public void setServerless(Serverless serverless) {
        this.serverless = serverless;
    }

    public Serverless getServerless() {
        return this.serverless;
    }

    public Cluster withServerless(Serverless serverless) {
        this.setServerless(serverless);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActiveOperationArn() != null) {
            sb.append("ActiveOperationArn: ").append(this.getActiveOperationArn()).append(",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: ").append(this.getClusterType()).append(",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getCurrentVersion() != null) {
            sb.append("CurrentVersion: ").append(this.getCurrentVersion()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateInfo() != null) {
            sb.append("StateInfo: ").append(this.getStateInfo()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getProvisioned() != null) {
            sb.append("Provisioned: ").append(this.getProvisioned()).append(",");
        }
        if (this.getServerless() != null) {
            sb.append("Serverless: ").append(this.getServerless());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getActiveOperationArn() == null ^ this.getActiveOperationArn() == null) {
            return false;
        }
        if (other.getActiveOperationArn() != null && !other.getActiveOperationArn().equals(this.getActiveOperationArn())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getCurrentVersion() == null ^ this.getCurrentVersion() == null) {
            return false;
        }
        if (other.getCurrentVersion() != null && !other.getCurrentVersion().equals(this.getCurrentVersion())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateInfo() == null ^ this.getStateInfo() == null) {
            return false;
        }
        if (other.getStateInfo() != null && !other.getStateInfo().equals(this.getStateInfo())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getProvisioned() == null ^ this.getProvisioned() == null) {
            return false;
        }
        if (other.getProvisioned() != null && !other.getProvisioned().equals(this.getProvisioned())) {
            return false;
        }
        if (other.getServerless() == null ^ this.getServerless() == null) {
            return false;
        }
        return other.getServerless() == null || other.getServerless().equals(this.getServerless());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActiveOperationArn() == null ? 0 : this.getActiveOperationArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentVersion() == null ? 0 : this.getCurrentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateInfo() == null ? 0 : this.getStateInfo().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getProvisioned() == null ? 0 : this.getProvisioned().hashCode());
        hashCode = 31 * hashCode + (this.getServerless() == null ? 0 : this.getServerless().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

