/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.kafka.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * TopicReplicationUpdateMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class TopicReplicationUpdateMarshaller {

    private static final MarshallingInfo<Boolean> COPYACCESSCONTROLLISTSFORTOPICS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("copyAccessControlListsForTopics").build();
    private static final MarshallingInfo<Boolean> COPYTOPICCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("copyTopicConfigurations").build();
    private static final MarshallingInfo<Boolean> DETECTANDCOPYNEWTOPICS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectAndCopyNewTopics").build();
    private static final MarshallingInfo<List> TOPICSTOEXCLUDE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topicsToExclude").build();
    private static final MarshallingInfo<List> TOPICSTOREPLICATE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("topicsToReplicate").build();

    private static final TopicReplicationUpdateMarshaller instance = new TopicReplicationUpdateMarshaller();

    public static TopicReplicationUpdateMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TopicReplicationUpdate topicReplicationUpdate, ProtocolMarshaller protocolMarshaller) {

        if (topicReplicationUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(topicReplicationUpdate.getCopyAccessControlListsForTopics(), COPYACCESSCONTROLLISTSFORTOPICS_BINDING);
            protocolMarshaller.marshall(topicReplicationUpdate.getCopyTopicConfigurations(), COPYTOPICCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(topicReplicationUpdate.getDetectAndCopyNewTopics(), DETECTANDCOPYNEWTOPICS_BINDING);
            protocolMarshaller.marshall(topicReplicationUpdate.getTopicsToExclude(), TOPICSTOEXCLUDE_BINDING);
            protocolMarshaller.marshall(topicReplicationUpdate.getTopicsToReplicate(), TOPICSTOREPLICATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
