/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ClusterOperationV2;
import java.util.Date;

@SdkInternalApi
public class ClusterOperationV2Marshaller {
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterArn").build();
    private static final MarshallingInfo<String> CLUSTERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterType").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInfo").build();
    private static final MarshallingInfo<String> OPERATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationArn").build();
    private static final MarshallingInfo<String> OPERATIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationState").build();
    private static final MarshallingInfo<String> OPERATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationType").build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("provisioned").build();
    private static final MarshallingInfo<StructuredPojo> SERVERLESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverless").build();
    private static final ClusterOperationV2Marshaller instance = new ClusterOperationV2Marshaller();

    public static ClusterOperationV2Marshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterOperationV2 clusterOperationV2, ProtocolMarshaller protocolMarshaller) {
        if (clusterOperationV2 == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)clusterOperationV2.getClusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getClusterType(), CLUSTERTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getErrorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getOperationArn(), OPERATIONARN_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getOperationState(), OPERATIONSTATE_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getOperationType(), OPERATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getProvisioned(), PROVISIONED_BINDING);
            protocolMarshaller.marshall((Object)clusterOperationV2.getServerless(), SERVERLESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

