/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.IndexEdition;
import com.amazonaws.services.kendra.model.ServerSideEncryptionConfiguration;
import com.amazonaws.services.kendra.model.Tag;
import com.amazonaws.services.kendra.model.UserContextPolicy;
import com.amazonaws.services.kendra.model.UserTokenConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIndexRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String edition;
    private String roleArn;
    private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private String description;
    private String clientToken;
    private List<Tag> tags;
    private List<UserTokenConfiguration> userTokenConfigurations;
    private String userContextPolicy;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateIndexRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public String getEdition() {
        return this.edition;
    }

    public CreateIndexRequest withEdition(String edition) {
        this.setEdition(edition);
        return this;
    }

    public CreateIndexRequest withEdition(IndexEdition edition) {
        this.edition = edition.toString();
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateIndexRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
        this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
    }

    public ServerSideEncryptionConfiguration getServerSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public CreateIndexRequest withServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
        this.setServerSideEncryptionConfiguration(serverSideEncryptionConfiguration);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateIndexRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIndexRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateIndexRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateIndexRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<UserTokenConfiguration> getUserTokenConfigurations() {
        return this.userTokenConfigurations;
    }

    public void setUserTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
        if (userTokenConfigurations == null) {
            this.userTokenConfigurations = null;
            return;
        }
        this.userTokenConfigurations = new ArrayList<UserTokenConfiguration>(userTokenConfigurations);
    }

    public CreateIndexRequest withUserTokenConfigurations(UserTokenConfiguration ... userTokenConfigurations) {
        if (this.userTokenConfigurations == null) {
            this.setUserTokenConfigurations(new ArrayList<UserTokenConfiguration>(userTokenConfigurations.length));
        }
        for (UserTokenConfiguration ele : userTokenConfigurations) {
            this.userTokenConfigurations.add(ele);
        }
        return this;
    }

    public CreateIndexRequest withUserTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
        this.setUserTokenConfigurations(userTokenConfigurations);
        return this;
    }

    public void setUserContextPolicy(String userContextPolicy) {
        this.userContextPolicy = userContextPolicy;
    }

    public String getUserContextPolicy() {
        return this.userContextPolicy;
    }

    public CreateIndexRequest withUserContextPolicy(String userContextPolicy) {
        this.setUserContextPolicy(userContextPolicy);
        return this;
    }

    public CreateIndexRequest withUserContextPolicy(UserContextPolicy userContextPolicy) {
        this.userContextPolicy = userContextPolicy.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getEdition() != null) {
            sb.append("Edition: ").append(this.getEdition()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getServerSideEncryptionConfiguration() != null) {
            sb.append("ServerSideEncryptionConfiguration: ").append(this.getServerSideEncryptionConfiguration()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getUserTokenConfigurations() != null) {
            sb.append("UserTokenConfigurations: ").append(this.getUserTokenConfigurations()).append(",");
        }
        if (this.getUserContextPolicy() != null) {
            sb.append("UserContextPolicy: ").append(this.getUserContextPolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getEdition() == null ^ this.getEdition() == null) {
            return false;
        }
        if (other.getEdition() != null && !other.getEdition().equals(this.getEdition())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getServerSideEncryptionConfiguration() == null ^ this.getServerSideEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getServerSideEncryptionConfiguration() != null && !other.getServerSideEncryptionConfiguration().equals(this.getServerSideEncryptionConfiguration())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getUserTokenConfigurations() == null ^ this.getUserTokenConfigurations() == null) {
            return false;
        }
        if (other.getUserTokenConfigurations() != null && !other.getUserTokenConfigurations().equals(this.getUserTokenConfigurations())) {
            return false;
        }
        if (other.getUserContextPolicy() == null ^ this.getUserContextPolicy() == null) {
            return false;
        }
        return other.getUserContextPolicy() == null || other.getUserContextPolicy().equals(this.getUserContextPolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getEdition() == null ? 0 : this.getEdition().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getServerSideEncryptionConfiguration() == null ? 0 : this.getServerSideEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getUserTokenConfigurations() == null ? 0 : this.getUserTokenConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getUserContextPolicy() == null ? 0 : this.getUserContextPolicy().hashCode());
        return hashCode;
    }

    public CreateIndexRequest clone() {
        return (CreateIndexRequest)super.clone();
    }
}

