/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.DataSourceGroup;

@SdkInternalApi
public class DataSourceGroupMarshaller {
    private static final MarshallingInfo<String> GROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupId").build();
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").build();
    private static final DataSourceGroupMarshaller instance = new DataSourceGroupMarshaller();

    public static DataSourceGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSourceGroup dataSourceGroup, ProtocolMarshaller protocolMarshaller) {
        if (dataSourceGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSourceGroup.getGroupId(), GROUPID_BINDING);
            protocolMarshaller.marshall((Object)dataSourceGroup.getDataSourceId(), DATASOURCEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

