/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.services.kendra.model.S3Path;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3PathJsonUnmarshaller
implements Unmarshaller<S3Path, JsonUnmarshallerContext> {
    private static S3PathJsonUnmarshaller instance;

    public S3Path unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Path s3Path = new S3Path();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Bucket", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Path.setBucket((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Key", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3Path.setKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Path;
    }

    public static S3PathJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3PathJsonUnmarshaller();
        }
        return instance;
    }
}

