/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kendra.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Summary information for frequently asked questions and answers included in an index.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/FaqSummary" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FaqSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identifier of the FAQ.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The name that you assigned the FAQ when you created or updated the FAQ.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The Unix timestamp when the FAQ was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The Unix timestamp when the FAQ was last updated.
     * </p>
     */
    private java.util.Date updatedAt;
    /**
     * <p>
     * The file type used to create the FAQ.
     * </p>
     */
    private String fileFormat;
    /**
     * <p>
     * The code for a language. This shows a supported language for the FAQ document as part of the summary information
     * for FAQs. English is supported by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     * other than English</a>.
     * </p>
     */
    private String languageCode;

    /**
     * <p>
     * The identifier of the FAQ.
     * </p>
     * 
     * @param id
     *        The identifier of the FAQ.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the FAQ.
     * </p>
     * 
     * @return The identifier of the FAQ.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the FAQ.
     * </p>
     * 
     * @param id
     *        The identifier of the FAQ.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FaqSummary withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The name that you assigned the FAQ when you created or updated the FAQ.
     * </p>
     * 
     * @param name
     *        The name that you assigned the FAQ when you created or updated the FAQ.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name that you assigned the FAQ when you created or updated the FAQ.
     * </p>
     * 
     * @return The name that you assigned the FAQ when you created or updated the FAQ.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name that you assigned the FAQ when you created or updated the FAQ.
     * </p>
     * 
     * @param name
     *        The name that you assigned the FAQ when you created or updated the FAQ.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FaqSummary withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * 
     * @param status
     *        The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @see FaqStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * 
     * @return The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @see FaqStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * 
     * @param status
     *        The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FaqStatus
     */

    public FaqSummary withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * </p>
     * 
     * @param status
     *        The current status of the FAQ. When the status is <code>ACTIVE</code> the FAQ is ready for use.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FaqStatus
     */

    public FaqSummary withStatus(FaqStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was created.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp when the FAQ was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was created.
     * </p>
     * 
     * @return The Unix timestamp when the FAQ was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was created.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp when the FAQ was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FaqSummary withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The Unix timestamp when the FAQ was last updated.
     */

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the FAQ was last updated.
     */

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * The Unix timestamp when the FAQ was last updated.
     * </p>
     * 
     * @param updatedAt
     *        The Unix timestamp when the FAQ was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FaqSummary withUpdatedAt(java.util.Date updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * <p>
     * The file type used to create the FAQ.
     * </p>
     * 
     * @param fileFormat
     *        The file type used to create the FAQ.
     * @see FaqFileFormat
     */

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    /**
     * <p>
     * The file type used to create the FAQ.
     * </p>
     * 
     * @return The file type used to create the FAQ.
     * @see FaqFileFormat
     */

    public String getFileFormat() {
        return this.fileFormat;
    }

    /**
     * <p>
     * The file type used to create the FAQ.
     * </p>
     * 
     * @param fileFormat
     *        The file type used to create the FAQ.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FaqFileFormat
     */

    public FaqSummary withFileFormat(String fileFormat) {
        setFileFormat(fileFormat);
        return this;
    }

    /**
     * <p>
     * The file type used to create the FAQ.
     * </p>
     * 
     * @param fileFormat
     *        The file type used to create the FAQ.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FaqFileFormat
     */

    public FaqSummary withFileFormat(FaqFileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
        return this;
    }

    /**
     * <p>
     * The code for a language. This shows a supported language for the FAQ document as part of the summary information
     * for FAQs. English is supported by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     * other than English</a>.
     * </p>
     * 
     * @param languageCode
     *        The code for a language. This shows a supported language for the FAQ document as part of the summary
     *        information for FAQs. English is supported by default. For more information on supported languages,
     *        including their codes, see <a
     *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     *        other than English</a>.
     */

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /**
     * <p>
     * The code for a language. This shows a supported language for the FAQ document as part of the summary information
     * for FAQs. English is supported by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     * other than English</a>.
     * </p>
     * 
     * @return The code for a language. This shows a supported language for the FAQ document as part of the summary
     *         information for FAQs. English is supported by default. For more information on supported languages,
     *         including their codes, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in
     *         languages other than English</a>.
     */

    public String getLanguageCode() {
        return this.languageCode;
    }

    /**
     * <p>
     * The code for a language. This shows a supported language for the FAQ document as part of the summary information
     * for FAQs. English is supported by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     * other than English</a>.
     * </p>
     * 
     * @param languageCode
     *        The code for a language. This shows a supported language for the FAQ document as part of the summary
     *        information for FAQs. English is supported by default. For more information on supported languages,
     *        including their codes, see <a
     *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding documents in languages
     *        other than English</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FaqSummary withLanguageCode(String languageCode) {
        setLanguageCode(languageCode);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt()).append(",");
        if (getFileFormat() != null)
            sb.append("FileFormat: ").append(getFileFormat()).append(",");
        if (getLanguageCode() != null)
            sb.append("LanguageCode: ").append(getLanguageCode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FaqSummary == false)
            return false;
        FaqSummary other = (FaqSummary) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        if (other.getFileFormat() == null ^ this.getFileFormat() == null)
            return false;
        if (other.getFileFormat() != null && other.getFileFormat().equals(this.getFileFormat()) == false)
            return false;
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null)
            return false;
        if (other.getLanguageCode() != null && other.getLanguageCode().equals(this.getLanguageCode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getFileFormat() == null) ? 0 : getFileFormat().hashCode());
        hashCode = prime * hashCode + ((getLanguageCode() == null) ? 0 : getLanguageCode().hashCode());
        return hashCode;
    }

    @Override
    public FaqSummary clone() {
        try {
            return (FaqSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kendra.model.transform.FaqSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
