/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SalesforceChatterFeedConfiguration;
import com.amazonaws.services.kendra.model.SalesforceKnowledgeArticleConfiguration;
import com.amazonaws.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration;
import com.amazonaws.services.kendra.model.SalesforceStandardObjectConfiguration;
import com.amazonaws.services.kendra.model.transform.SalesforceConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SalesforceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String serverUrl;
    private String secretArn;
    private List<SalesforceStandardObjectConfiguration> standardObjectConfigurations;
    private SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration;
    private SalesforceChatterFeedConfiguration chatterFeedConfiguration;
    private Boolean crawlAttachments;
    private SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration;
    private List<String> includeAttachmentFilePatterns;
    private List<String> excludeAttachmentFilePatterns;

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public SalesforceConfiguration withServerUrl(String serverUrl) {
        this.setServerUrl(serverUrl);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public SalesforceConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public List<SalesforceStandardObjectConfiguration> getStandardObjectConfigurations() {
        return this.standardObjectConfigurations;
    }

    public void setStandardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration> standardObjectConfigurations) {
        if (standardObjectConfigurations == null) {
            this.standardObjectConfigurations = null;
            return;
        }
        this.standardObjectConfigurations = new ArrayList<SalesforceStandardObjectConfiguration>(standardObjectConfigurations);
    }

    public SalesforceConfiguration withStandardObjectConfigurations(SalesforceStandardObjectConfiguration ... standardObjectConfigurations) {
        if (this.standardObjectConfigurations == null) {
            this.setStandardObjectConfigurations(new ArrayList<SalesforceStandardObjectConfiguration>(standardObjectConfigurations.length));
        }
        for (SalesforceStandardObjectConfiguration ele : standardObjectConfigurations) {
            this.standardObjectConfigurations.add(ele);
        }
        return this;
    }

    public SalesforceConfiguration withStandardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration> standardObjectConfigurations) {
        this.setStandardObjectConfigurations(standardObjectConfigurations);
        return this;
    }

    public void setKnowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
        this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
    }

    public SalesforceKnowledgeArticleConfiguration getKnowledgeArticleConfiguration() {
        return this.knowledgeArticleConfiguration;
    }

    public SalesforceConfiguration withKnowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
        this.setKnowledgeArticleConfiguration(knowledgeArticleConfiguration);
        return this;
    }

    public void setChatterFeedConfiguration(SalesforceChatterFeedConfiguration chatterFeedConfiguration) {
        this.chatterFeedConfiguration = chatterFeedConfiguration;
    }

    public SalesforceChatterFeedConfiguration getChatterFeedConfiguration() {
        return this.chatterFeedConfiguration;
    }

    public SalesforceConfiguration withChatterFeedConfiguration(SalesforceChatterFeedConfiguration chatterFeedConfiguration) {
        this.setChatterFeedConfiguration(chatterFeedConfiguration);
        return this;
    }

    public void setCrawlAttachments(Boolean crawlAttachments) {
        this.crawlAttachments = crawlAttachments;
    }

    public Boolean getCrawlAttachments() {
        return this.crawlAttachments;
    }

    public SalesforceConfiguration withCrawlAttachments(Boolean crawlAttachments) {
        this.setCrawlAttachments(crawlAttachments);
        return this;
    }

    public Boolean isCrawlAttachments() {
        return this.crawlAttachments;
    }

    public void setStandardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration) {
        this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
    }

    public SalesforceStandardObjectAttachmentConfiguration getStandardObjectAttachmentConfiguration() {
        return this.standardObjectAttachmentConfiguration;
    }

    public SalesforceConfiguration withStandardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration) {
        this.setStandardObjectAttachmentConfiguration(standardObjectAttachmentConfiguration);
        return this;
    }

    public List<String> getIncludeAttachmentFilePatterns() {
        return this.includeAttachmentFilePatterns;
    }

    public void setIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
        if (includeAttachmentFilePatterns == null) {
            this.includeAttachmentFilePatterns = null;
            return;
        }
        this.includeAttachmentFilePatterns = new ArrayList<String>(includeAttachmentFilePatterns);
    }

    public SalesforceConfiguration withIncludeAttachmentFilePatterns(String ... includeAttachmentFilePatterns) {
        if (this.includeAttachmentFilePatterns == null) {
            this.setIncludeAttachmentFilePatterns(new ArrayList<String>(includeAttachmentFilePatterns.length));
        }
        for (String ele : includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns.add(ele);
        }
        return this;
    }

    public SalesforceConfiguration withIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
        this.setIncludeAttachmentFilePatterns(includeAttachmentFilePatterns);
        return this;
    }

    public List<String> getExcludeAttachmentFilePatterns() {
        return this.excludeAttachmentFilePatterns;
    }

    public void setExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
        if (excludeAttachmentFilePatterns == null) {
            this.excludeAttachmentFilePatterns = null;
            return;
        }
        this.excludeAttachmentFilePatterns = new ArrayList<String>(excludeAttachmentFilePatterns);
    }

    public SalesforceConfiguration withExcludeAttachmentFilePatterns(String ... excludeAttachmentFilePatterns) {
        if (this.excludeAttachmentFilePatterns == null) {
            this.setExcludeAttachmentFilePatterns(new ArrayList<String>(excludeAttachmentFilePatterns.length));
        }
        for (String ele : excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns.add(ele);
        }
        return this;
    }

    public SalesforceConfiguration withExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
        this.setExcludeAttachmentFilePatterns(excludeAttachmentFilePatterns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerUrl() != null) {
            sb.append("ServerUrl: ").append(this.getServerUrl()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getStandardObjectConfigurations() != null) {
            sb.append("StandardObjectConfigurations: ").append(this.getStandardObjectConfigurations()).append(",");
        }
        if (this.getKnowledgeArticleConfiguration() != null) {
            sb.append("KnowledgeArticleConfiguration: ").append(this.getKnowledgeArticleConfiguration()).append(",");
        }
        if (this.getChatterFeedConfiguration() != null) {
            sb.append("ChatterFeedConfiguration: ").append(this.getChatterFeedConfiguration()).append(",");
        }
        if (this.getCrawlAttachments() != null) {
            sb.append("CrawlAttachments: ").append(this.getCrawlAttachments()).append(",");
        }
        if (this.getStandardObjectAttachmentConfiguration() != null) {
            sb.append("StandardObjectAttachmentConfiguration: ").append(this.getStandardObjectAttachmentConfiguration()).append(",");
        }
        if (this.getIncludeAttachmentFilePatterns() != null) {
            sb.append("IncludeAttachmentFilePatterns: ").append(this.getIncludeAttachmentFilePatterns()).append(",");
        }
        if (this.getExcludeAttachmentFilePatterns() != null) {
            sb.append("ExcludeAttachmentFilePatterns: ").append(this.getExcludeAttachmentFilePatterns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConfiguration)) {
            return false;
        }
        SalesforceConfiguration other = (SalesforceConfiguration)obj;
        if (other.getServerUrl() == null ^ this.getServerUrl() == null) {
            return false;
        }
        if (other.getServerUrl() != null && !other.getServerUrl().equals(this.getServerUrl())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getStandardObjectConfigurations() == null ^ this.getStandardObjectConfigurations() == null) {
            return false;
        }
        if (other.getStandardObjectConfigurations() != null && !other.getStandardObjectConfigurations().equals(this.getStandardObjectConfigurations())) {
            return false;
        }
        if (other.getKnowledgeArticleConfiguration() == null ^ this.getKnowledgeArticleConfiguration() == null) {
            return false;
        }
        if (other.getKnowledgeArticleConfiguration() != null && !other.getKnowledgeArticleConfiguration().equals(this.getKnowledgeArticleConfiguration())) {
            return false;
        }
        if (other.getChatterFeedConfiguration() == null ^ this.getChatterFeedConfiguration() == null) {
            return false;
        }
        if (other.getChatterFeedConfiguration() != null && !other.getChatterFeedConfiguration().equals(this.getChatterFeedConfiguration())) {
            return false;
        }
        if (other.getCrawlAttachments() == null ^ this.getCrawlAttachments() == null) {
            return false;
        }
        if (other.getCrawlAttachments() != null && !other.getCrawlAttachments().equals(this.getCrawlAttachments())) {
            return false;
        }
        if (other.getStandardObjectAttachmentConfiguration() == null ^ this.getStandardObjectAttachmentConfiguration() == null) {
            return false;
        }
        if (other.getStandardObjectAttachmentConfiguration() != null && !other.getStandardObjectAttachmentConfiguration().equals(this.getStandardObjectAttachmentConfiguration())) {
            return false;
        }
        if (other.getIncludeAttachmentFilePatterns() == null ^ this.getIncludeAttachmentFilePatterns() == null) {
            return false;
        }
        if (other.getIncludeAttachmentFilePatterns() != null && !other.getIncludeAttachmentFilePatterns().equals(this.getIncludeAttachmentFilePatterns())) {
            return false;
        }
        if (other.getExcludeAttachmentFilePatterns() == null ^ this.getExcludeAttachmentFilePatterns() == null) {
            return false;
        }
        return other.getExcludeAttachmentFilePatterns() == null || other.getExcludeAttachmentFilePatterns().equals(this.getExcludeAttachmentFilePatterns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerUrl() == null ? 0 : this.getServerUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getStandardObjectConfigurations() == null ? 0 : this.getStandardObjectConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getKnowledgeArticleConfiguration() == null ? 0 : this.getKnowledgeArticleConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getChatterFeedConfiguration() == null ? 0 : this.getChatterFeedConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlAttachments() == null ? 0 : this.getCrawlAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getStandardObjectAttachmentConfiguration() == null ? 0 : this.getStandardObjectAttachmentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeAttachmentFilePatterns() == null ? 0 : this.getIncludeAttachmentFilePatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeAttachmentFilePatterns() == null ? 0 : this.getExcludeAttachmentFilePatterns().hashCode());
        return hashCode;
    }

    public SalesforceConfiguration clone() {
        try {
            return (SalesforceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

